class DefaultConfig(object):

    # important configurations:
    # dataset: victim_dataset, public_dataset (generator, pre-trained, simclr, surrogate)
    # noise level corresponding to dataset: noise_eps, noise_step, eps_multiple
    # model: victim_model, substitute_model (pre-trained, simclr, sub, eval)
    # pre-train strategy: pre_train_sub
    # attack strategy: source, gen_model
    # substitute training strategy: sub_optim, sub_lr, scheduler, batchsize
    # training epoch: epoch, gen_epoch, div_epoch
    # query number: n_loop, query
    # stop condition: loss_rise_epoch
    # save and load substitute model: sub_save_loop, sub_eval_loop
    # weight for different loss terms: noise_weight, adv_weight, div_weight, pseudo_label_weight; div_threshold
    # defense: victim_wm_dataset (for entangled wm), victim_ood_dataset (for cip)
    # truncation: victim_return_type
    # fuse image number: n_fuse
    # enlarge setting: enlarge_every_loop
    # dataset weight: dataset_decay
    # gpu id, seed

    # training options
    work_dir    = '[HOME_DIR]/substitute_attack_demo/'
    data_dir    = '[HOME_DIR]/substitute_attack_demo/'
    use_gpu     = True
    gpu_id      = '3'
    print_epoch  =True
    print_freq  = 5#2
    seed = 1000 # 600

    ''' =======================
         victim configurations
        =======================
    '''
    victim_model     = 'resnet34'#'efficientnet-b7''resnet18''resnet34''resnet50''densenet''pyramidnet''resnext''wrn-28'
    # 'inceptionv3''vgg''eweresnet50'''mobilenetv1''mobilenetv2'
    victim_dataset   = 'cifar10' #'cifar10''cifar100''TinyImageNet''noise''ImageNet''cifar100-10pct''cifar100-10cls''svhn'
    victim_img_size  = 32
    # victim_n_classes = 10 #10
    if 'cifar' in victim_dataset:
        if '100' in victim_dataset:
            victim_n_classes = 100
        else:
            victim_n_classes = 10
    else:
        victim_n_classes = 10

    # victim training
    victim_epoch     = 100 #200 #100 #20000
    victim_optim     = 'sgd' #'sgd''adam'
    victim_lr        = 0.1 #0.0002 0.1 0.001
    victim_lr_decay  = 0.99
    victim_weight_decay = 5e-4 #0.001
    victim_wm_dataset = None #'svhn'
    victim_ood_dataset = None #'TinyImageNet'

    # defense
    prada_test = False
    victim_return_type = 'original' # 'original' 'noise' 'label' 'top-3' 'round-1' (keep how many decimals: 0.91->0.9)

    public_dataset = 'cifar100'
    substitute_model = 'resnet34'

    ''' ===============================================
         substitute offline pre-training configurations
        ===============================================
    '''
    pre_train_sub      = 'simclr' # 'pre''simclr'None
    pre_sub_model      = substitute_model #'resnet50'
    pre_sub_dataset    = public_dataset
    pre_sub_img_size   = 32
    # pre_sub_n_classes  = 100 #100
    if 'cifar' in pre_sub_dataset:
        if '100' in pre_sub_dataset:
            pre_sub_n_classes = 100
        else:
            pre_sub_n_classes = 10
    else:
        pre_sub_n_classes = 10
    pre_sub_pre_epoch  = 100
    pre_sub_optim      = 'adam'
    pre_sub_pre_lr     = 0.0005

    ''' =============================================
         query generator pre-training configurations
        =============================================
    '''
    gen_model    = 'fusiongan' #'progan''attackgan''random_aggr_gen''fusiongan'
    pre_gen_epoch = 100#1000
    pre_query = int(22000)
    noise_dim    = 64
    gen_pretrain = False #True
    gen_dataset  = public_dataset
    gen_img_size = 32
    gen_optim    = 'adam'
    gen_lr       = 0.001 #0.0002
    gen_next_lr  = 0.0002 #0.0002 #0.001

    # SimCLR parameters
    simclr_model = substitute_model
    simclr_sub_epoch = 200 #300 200
    simclr_gen_epoch = 200
    simclr_dataset = public_dataset
    projection_dim = 64 #64
    simclr_sub_batch_size = 1100 #500 600 2400 1200 1000 3100 1400
    simclr_gen_batch_size = 2500
    temperature = 0.5#0.5
    world_size = 1
    simclr_lr = 3e-4#3e-4
    simclr_weight_decay = 0#1e-6

    ''' ===============================================
         substitute online training configurations
        ===============================================
    '''
    surrogate_dataset = public_dataset
    public_img_size = 32
    strategy = 'adaptive'#'every''static'
    '''
    query strategy:
    static: query all badget in single query
    adaptive: batch query
    every: query every iteration
    '''
    sub_optim = 'sgd'#'sgd''adam'
    sub_lr = 0.1 #3e-4 #5e-4 #0.001 #0.1
    sub_weight_decay = 5e-4
    online_simclr_lr = 3e-4
    source = 'fusiongan' #'fusiongan''active-kc''active-df''random''papernot''mosafi''random_aggr_gen''avg''fusiongan-label'
    n_fuse = 3 #3 1
    sub_model = substitute_model #'disresnet50' #'newresnet50''resnet50''resnext'
    eval_model = substitute_model #'newresnet50''resnet50''resnext'
    query = int(100000) #int(2e5) int(1e4) int(1500000)
    epoch = 100#50 #20 # 5
    gen_epoch = 5#5
    div_epoch = 0#2#5
    n_loop = 4 #4 #20 # 200

    # if query per loop is larger than public dataset, enlarge pub data
    enlarge_every_loop = False
    large_dataset_noise_std = 0.05

    # evaluate configurations
    sub_save_loop = None
    sub_eval_loop = None # 14
    visualize_dataset = False #True

    # loss weight
    noise_weight = 2 #1e5
    adv_weight = 1#1
    div_weight = 4e-5#2e-5 1e-5 #2e-9
    uncertain_weight = 0
    cw_weight = 0#1
    pseudo_label_weight = 0 #0.01#0.05
    cls_div_weight = 0.3#0.1
    simclr_weight = 0.1

    div_threshold = 0.6 #1.2 0.5

    same_origin = False
    loss_threshhold = None #0.01
    loss_rise_epoch = 2 #2 3
    div_rise_epoch = None#6#3
    same_certainty_epoch = None #5
    certainty_threshhold = None #0.77
    noise_fall_epoch = None #5
    targeted = False
    epoch_val_rate = 0
    dataset_decay = 0.8#0.8

    papernot_init = 11 if victim_dataset == 'cifar10' else 5
    papernot_lamb = 0.1
    if source == 'papernot':
        if victim_dataset == 'cifar10':
            n_loop = 7
        elif victim_dataset == 'cifar100':
            n_loop = 5
    if source == 'mosafi':
        epoch = 1

    # the eps value needs to be scaled 
    # according to the implementation of advertorch
    noise_eps = 0.3 #0.2 0.35 0.3 # 0.1 0.09 
    noise_step = 30 #35 30 #50 #70 #200
    eps_multiple = 2#1

    continue_train = True
    n_pseudo = int(5e5)
    pseudo_epoch = 50 #150
    pseudo_dataset = 'all' #'new'
    
    caption = f'{strategy}_{source}_{query}query_{noise_eps}eps'
    plot = False
    title = 'no_pre_kd' # f'hori_{epoch}epoch_{noise_eps}eps_{eps_multiple}iter'

    # train data generator

    # train adversarial generator


opt = DefaultConfig()
