import torch
import torch.nn as nn
from torch.autograd import Variable


class Block1(nn.Module):
	def __init__(self, name=None):
		super().__init__()
		self.name = name

	def forward(self, x):
		return x+torch.Tensor([2])

class Net(nn.Module):
	def __init__(self):
		super().__init__()
		self.block1 = Block1()
		self.grad_map = {}
		hook = self.block1.register_backward_hook(self.backward_hook)

	def backward_hook(self, module, input_grad, output_grad):
		# print(dir(module))
		print(module.name)
		return

	def forward(self, x):
		y = self.block1(x)
		z = y*y
		return z

loss_func = nn.MSELoss()
net = Net()
# print(net.block1.__dict__)
# print(net.grad_map['y_grad'])
input = torch.Tensor([1, 2])
input = Variable(input, requires_grad=True)
output = net(input)
target = torch.Tensor([3, 4])
loss = loss_func(output, target)
loss.backward()
# print(net.grad_map['y_grad'])
