from setup import *
from config import opt
import os


def main():
    os.environ["CUDA_VISIBLE_DEVICES"] = opt.gpu_id

    # print training configuration
    pid = os.getpid()
    print('PID:',pid)
    print_config()

    # set random seed
    setup_seed(opt.seed)

    # pre-train
    victim = prepare_victim()
    substitute = prepare_substitute()
    data_gen = prepare_data_gen()
    victim.eval()

    # train substitute
    train_substitute(
        victim, substitute, data_gen,
        strategy=opt.strategy, source=opt.source
    )


if __name__ == '__main__':
    main()
