import sys
sys.path.append('..')
import os
os.environ['CUDA_VISIBLE_DEVICES']='1'

import torch
from thop import profile

import classifier

model_names = ['resnet-34', 'pyramidnet', 'resnext', 'wrn-28', 'inceptionv3', 'cifar_resnext', 'densenet', 'mobilenetv1']

model_list = []
model_list.append(classifier.ResNet34(n_outputs=10))
model_list.append(classifier.PyramidNet(n_outputs=10))
model_list.append(classifier.ResNeXt(n_outputs=10))
model_list.append(classifier.WideResNet(n_outputs=10, depth=28))
model_list.append(classifier.InceptionV3(n_outputs=10))
model_list.append(classifier.CifarResNeXt(n_outputs=10))
model_list.append(classifier.DenseNet(n_outputs=10))
model_list.append(classifier.MobileNetV1(n_outputs=10))
inputs = torch.randn(1, 3, 32, 32).cuda()
for i in range(len(model_list)):
    flops, params = profile(model_list[i].cuda(), inputs=(inputs, ))
    print(model_names[i])
    print('Params = ' + str(params/1000**2) + 'M')
    print('FLOPs = ' + str(flops/1000**2) + 'M')