import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import sys
sys.path.append('..')
from config import opt

plt.rcParams['font.sans-serif'] = 'Times New Roman'

plt.figure(figsize=(8, 4))
# 构造x轴刻度标签、数据
label_list = ['Mosafi', 'ActiveThief', 'DFMS-SL', 'SEEKER']
# labels = ['10%', '30%', '50%', '100%']
labels = ['CIFAR-100(30%)', 'CIFAR-100(50%)', 'CIFAR-100(70%)', 'CIFAR-100(100%)', ]
first = [24.4, 24.7, 26, 26]
second = [53.3, 62.6, 70, 75]
third = [48, 50, 53, 55]
fourth = [75.5, 83, 85.3, 88.0]

# # 三组数据
# plt.subplot(132)
# x = np.arange(len(labels))  # x轴刻度标签位置
# width = 0.25  # 柱子的宽度
# # 计算每个柱子在x轴上的位置，保证x轴刻度标签居中
# # x - width，x， x + width即每组数据在x轴上的位置
# plt.bar(x - width, first, width, label='1')
# plt.bar(x, second, width, label='2')
# plt.bar(x + width, third, width, label='3')
# plt.ylabel('Scores')
# plt.title('3 datasets')
# # x轴刻度标签位置不进行计算
# plt.xticks(x, labels=labels)
# plt.legend()

title='small dataset test'
# 四组数据
# plt.subplot(133)
x = np.arange(len(labels))  # x轴刻度标签位置
width = 0.2  # 柱子的宽度
# 计算每个柱子在x轴上的位置，保证x轴刻度标签居中
plt.bar(x - 1.5*width, first, width, label=label_list[0], color='firebrick')
plt.bar(x - 0.5*width, second, width, label=label_list[1], color='peru')
plt.bar(x + 0.5*width, third, width, label=label_list[2], color='darkcyan')
plt.bar(x + 1.5*width, fourth, width, label=label_list[3], color='darkblue')
plt.ylabel('Acc')
plt.title(title)
# x轴刻度标签位置不进行计算
plt.xticks(x, labels=labels)
plt.legend()

save_dir = f'{opt.work_dir}results/rect_chart/'
save_name = '_'.join(title.split(' '))
plt.savefig(f'{save_dir}{save_name}.png')
