from argparse import ArgumentParser

def init_parser():
    parser = ArgumentParser()
    parser.add_argument('--rep0', '-r0', type=int, default=0,
                            help="starting experiment id")
    parser.add_argument('--repn', '-rn', type=int, default=1,
                            help="number of experiment replication")
    parser.add_argument('--size','-sz',type=int,default=2,
                            help='sample set of size 4**size')
    parser.add_argument('--compressalg','-ca',type =str , default = "thin") # algorithm used inside compress
    parser.add_argument('--symm1','-symm1',type =int , default = 0) # whether to symmetrize in stage 1
    parser.add_argument('--rh2','-rh2',type =int , default = 0) # whether to use rechalving of the compressalg in stage 2; will enforce unique points
    
    parser.add_argument('--alpha','-alp',type=int, default = 0) # range of alpha for compress++
    parser.add_argument('--seed','-ssd',type=int,default=123456789)
    parser.add_argument('--rerun','-rr',type=int, default = 0) # set to value other than 0 to rerun
    parser.add_argument('--store_K', '-sk', type=bool, default=False,
                            help="whether to save K matrix, 2-3x faster runtime, but larger memory O(n^2)")
    parser.add_argument('--m', '-m', type=int, default=2,
                            help="number of thinning rounds")
    parser.add_argument('--d', '-d', type=int, default=2,
                            help="dimensions")
    parser.add_argument('--M', '-M', type=int, default=None,
                            help="number of mixture for diag mog in d=2")
    parser.add_argument('--filename', '-f', type=str, default=None,
                           help="name for saved (MCMC) samples") 
    parser.add_argument('--computemmd', '-cmmd', type=int, default=0,
                            help="set to anything other than 0 to compute mmd results")
    parser.add_argument('--recomputemmd', '-rcmmd', type=int, default=0,
                            help="whether to re-compute mmd results, set to anything other than 0 ")
    parser.add_argument('--ncompress', '-ncompress', type=int, default=2,
                            help="how many compress coresets to generate")
    parser.add_argument('--setting', '-setting', type=str, default="gauss",
                            help="what P setting to run the experiment")
    parser.add_argument('--krt', '-krt', type=int, default=0, # 0 means do not use krt; set to anything other than 0 to use ktrt
                            help="whether to use krt for kt.split")
    parser.add_argument('--thinalg', '-talg' , type=str, default="kt") # useful only for run_time function; which thin algorithm is being profiled
    parser.add_argument('--prefix', '-prefix' , type=str, default="") # useful only for run_time function; what prefix to use for saving results
    
    return(parser)