#!/bin/bash
export CUDA_VISIBLE_DEVICES=3,4,5
####################
# datasets=(epistemic_reasoning movie_recommendation timedial presuppositions_as_nli question_selection)
datasets=(epistemic_reasoning)
####################
# Llama 3
MODEL_DIR='meta-llama/Meta-Llama-3-8B-Instruct'
MODEL_NAME='llama3'
#
#########################
export TRANSFORMERS_CACHE=./HF_CACHE_DIR
for i in ${datasets[@]}; do
    python ./run_AIO.py \
        --model_name ${MODEL_NAME} \
        --task $i \
        --HF_cache_dir ${MODEL_DIR} \
        --gpt Claude_3 \
        --few_shot_sample_num 20 \
        --evaluation_sample_num 100 \
        --max_seq_length 2000 \
        --zero_shot_evaluation_flag
done