import click
from agentgym.task_suites import SUITES


def check_suite(suite_name: str):
    if suite_name not in SUITES:
        raise ValueError(f"Unknown suite: {suite_name}")
    suite = SUITES[suite_name]
    print(f"\033[94mChecking suite: `{suite.name}`\033[00m")

    _, (user_tasks_results, injection_tasks_results) = suite.check()

    ok = True

    if all(result[0] for result in user_tasks_results.values()):
        print(f"\033[92mSuite '{suite.name}' passed for all {len(suite.user_tasks)} user tasks!\033[00m")
    else:
        print(f"\033[91mSuite '{suite.name}' failed for some user tasks!\033[00m")
        ok = False
    if all(result for result in injection_tasks_results.values()):
        print(f"\033[92mSuite '{suite.name}' passed for all {len(suite.injection_tasks)} injection tasks!\033[00m")
    else:
        print(f"\033[91mSuite '{suite.name}' failed for some injection tasks!\033[00m")
        ok = False

    for user_task_id, result in user_tasks_results.items():
        if not result[0]:
            print(f"\033[91mUser task '{user_task_id}' failed: {result[1]}\033[00m")

    for injection_task_id, result in injection_tasks_results.items():
        if not result:
            print(f"\033[91mThe ground truth does not solve the injection task task '{injection_task_id}'\033[00m")

    return ok


@click.command()
@click.option(
    "--suite",
    "-s",
    "suites",
    type=str,
    multiple=True,
    default=tuple(),
)
def main(suites: list[str]):
    if len(suites) == 0:
        suites = list(SUITES.keys())
    for suite in suites:
        check_suite(suite)


if __name__ == "__main__":
    main()
