import abc
from collections.abc import Sequence

from agentgym.functions_engine.functions_engine import Env, Function
from agentgym.types import ChatMessage, DummyEnv


class BasePipelineElement(abc.ABC):
    name: str | None = None

    @abc.abstractmethod
    def query(
        self,
        query: str,
        tools: Sequence[Function],
        env: Env = DummyEnv(),
        messages: Sequence[ChatMessage] = [],
        extra_args: dict = {},
    ) -> tuple[str, Sequence[Function], Env, Sequence[ChatMessage], dict]:
        pass
