from=${1}   #"bc_policy "
to=${2}  #"meta_policy"
out="./out_redm"
test_mode=${3}
commander=${4}
task=${5}
type=${6}
exp_name="${num_cand}-models"

all_tasks=("$task-$type")

export PYTHONPATH=.:$PYTHONPATH

workflow=( "bc_policy" "dynamics" "candidate_model" "meta_policy")
echo "config"
function launch_one_exp() {
    task=$1
    from=$2
    to=$3
    trans_path="./transition_model_nodata/$task.pt"
    local idx=0
    for entry in ${workflow[@]}
    do
        if [ "$entry" = "$from" ]; then
            from_idx=$idx
        fi
        if [ "$entry" = "$to" ]; then
            to_idx=$idx
        fi
        idx=$(( $idx + 1 ))
    done
    base_cmd="python3 examples/train_redm_offline.py --algo_name poco --task d4rl-${task}-v2 --test_mode ${test_mode} --from ${from} --to ${to} ${commander}"
    for entry in ${workflow[@]::$from_idx}
    do

        if [ ! -d "${out}/${entry}/${task}/" ]; then
          mkdir -p "${out}/${entry}/${task}/"
        fi

        base_cmd=$base_cmd" --${entry}_path ${out}/${entry}/${task}/"
        # echo $base_cmd
    done
    for entry in ${workflow[@]:$from_idx:$(( $to_idx - $from_idx + 1 ))}
    do
        if [ ! -d "${out}/${entry}/${task}/" ]; then
          mkdir -p "${out}/${entry}/${task}/"
        fi
        base_cmd=$base_cmd" --${entry}_path ${out}/${entry}/${task}/"
        # echo $base_cmd
    done
    echo $base_cmd
}

if [ ! -e ${out}/logs ]; then
    mkdir -p ${out}/logs
fi

export D4RL_SUPPRESS_IMPORT_ERROR=1

if [ ! -f "${out}/logs/${info}.stdout" ]; then
  touch "${out}/logs/${info}.stdout"
fi


for task in ${all_tasks[@]}
do
    cmd=`launch_one_exp $task $from $to`
    echo $cmd
    info="${exp_name}-${task}"
    echo $cmd --stop_point $to --exp_name "$info" "> ${out}/logs/${info}.stdout 2>&1"
    $cmd --stop_point $to --exp_name "$info" > "${out}/logs/${info}.stdout" 2>&1
done
