import os
import base64
import re
import json
import hashlib
from typing import Dict, Any, Optional
from io import BytesIO
import torch
import numpy as np

def pil_to_base64(pil_image) -> str:
    import base64
    import io
    
    img_byte_arr = io.BytesIO()
    pil_image.save(img_byte_arr, format='PNG')
    img_byte_arr = img_byte_arr.getvalue()
    return base64.b64encode(img_byte_arr).decode('utf-8')

def path_to_openbayes_url(file_path: str) -> str:
    import os
    import urllib.parse
    
    if file_path.startswith('/openbayes/'):
        relative_path = file_path[len('/openbayes/'):]
    else:
        relative_path = file_path
    
    encoded_path = urllib.parse.quote(relative_path, safe='/')
    
    base_url = "XXX"
    return f"{base_url}/{encoded_path}"
