JSB Experiments
===============

Code for running the experiments in the paper
Logical Activation Functions: Logit-space equivalents of Probabilistic Boolean Operators
https://openreview.net/forum?id=m6HNNpQO8dc
on the JSB dataset.


## Installation

Set up environment and install dependencies.

```sh
# Example install
ENVNAME=ail-jsb
echo "Setting up environment $ENVNAME"
conda create --name "$ENVNAME" -q python=3.6 pip

# Activate the environment
conda activate "$ENVNAME"

# Install dependencies
conda install pytorch=1.7.1 cudatoolkit=11.0 -c pytorch
conda install scipy
```

To plot the results, additional dependencies are needed:
```sh
conda install matplotlib numpy seaborn
```


## Experiment 1: JSB Chorales accuracy curves

Run the experiments:
```
for IDX in {1..91}; do
    python train_jsb_actfun_acc.py --epochs 150 --lr 0.001 --seq_len 4 --batch_size 32 --idx "$IDX"
done
```

Plot the results:
```
python plot_jsb_actfun_acc.py
```


## Experiment 2: Cosine similarities between preactivations

Run the experiments:
```
for IDX in {1..13}; do
    python train_jsb_actfun_weights.py --epochs 150 --lr 0.001 --seq_len 4 --batch_size 32 --idx "$IDX"
done
```

Plot the results:
```
python plot_jsb_actfun_weights.py
```
