#!/bin/bash

# Store the time at which the script was launched
start_time=$SECONDS

echo "------------------------------------------------------------------------"
date

DATASET="mit-states"
N_WORKERS=2

JOBNAME="$1"
shift
HWIDTH="$1"
shift

echo "JOBNAME = $JOBNAME"
echo "DATASET = $DATASET"
echo "HWIDTH  = $HWIDTH"
echo ""

echo "# TRAINING"
echo "# Running train_modular.py"
python train_modular.py \
    --name "$JOBNAME" \
    --cv_dir "models-tmn/$DATASET" \
    --data_dir "data/$DATASET" \
    --seed "$SEED" \
    --batch_size 128 \
    --batch_accumulation 2 \
    --lr 0.001 \
    --lrg 0.01 \
    --num_negs 600 \
    --gater_type general \
    --embed_rank "$HWIDTH" \
    --module_hidden "$HWIDTH" \
    --glove_init \
    --test_batch_size 32 \
    --adam \
    --max_epochs 300 \
    --workers "$N_WORKERS" \
    "${@}"
echo ""
elapsed=$(( SECONDS - start_time ))
eval "echo Total elapsed time: $(date -ud "@$elapsed" +'$((%s/3600/24)) days %H hr %M min %S sec')"
date
echo ""
echo "# TESTING for model with best validation performance"
for TOPK in 1 2 3
do
    echo ""
    echo "# Running test_modular.py (topk = $TOPK)"
    python test_modular.py \
        --name "$JOBNAME" \
        --cv_dir "models-tmn/$DATASET" \
        --load "models-tmn/$DATASET/$JOBNAME/ckpt_best.t7" \
        --data_dir "data/$DATASET" \
        --seed "$SEED" \
        --gater_type general \
        --embed_rank "$HWIDTH" \
        --module_hidden "$HWIDTH" \
        --glove_init \
        --test_batch_size 32 \
        --test_set test \
        --topk "$TOPK" \
        --workers "$N_WORKERS" \
        "${@}"
done
