#!/bin/bash

# Store the time at which the script was launched
start_time=$SECONDS

echo "------------------------------------------------------------------------"
date

DATASET="mit-states"
N_WORKERS=2

JOBNAME="$1"
shift
HWIDTH="$1"
shift

echo "JOBNAME = $JOBNAME"
echo "DATASET = $DATASET"
echo "HWIDTH  = $HWIDTH"
echo ""

echo "# TRAINING"
echo "# Running train_modular.py"
python train_modular.py \
    --name "$JOBNAME" \
    --cv_dir "models-tmnx/$DATASET" \
    --data_dir "data/$DATASET" \
    --batch_size 64 \
    --batch_accumulation 2 \
    --num_negs 600 \
    --gater_type generalb \
    --embed_rank "$HWIDTH" \
    --module_hidden "$HWIDTH" \
    --glove_init \
    --test_batch_size 32 \
    --adam \
    --max_epochs 300 \
    --workers "$SLURM_JOB_CPUS_PER_NODE" \
    "${@}"
echo ""
elapsed=$(( SECONDS - start_time ))
eval "echo Total elapsed time: $(date -ud "@$elapsed" +'$((%s/3600/24)) days %H hr %M min %S sec')"
date
echo ""
echo "# TESTING for model with best validation performance"
for TOPK in 1 2 3
do
    echo ""
    echo "# Running test_modular.py (topk = $TOPK)"
    python test_modular.py \
        --name "$JOBNAME" \
        --cv_dir "models-tmnx/$DATASET" \
        --load "models-tmnx/$DATASET/$JOBNAME/ckpt_best.t7" \
        --data_dir "data/$DATASET" \
        --gater_type generalb \
        --embed_rank "$HWIDTH" \
        --module_hidden "$HWIDTH" \
        --glove_init \
        --test_batch_size 32 \
        --test_set test \
        --topk "$TOPK" \
        --workers "$SLURM_JOB_CPUS_PER_NODE" \
        "${@}"
done
echo ""
elapsed=$(( SECONDS - start_time ))
eval "echo Total elapsed time: $(date -ud "@$elapsed" +'$((%s/3600/24)) days %H hr %M min %S sec')"
date
