#!/bin/bash
# Runs analysis for the main results.
#
# Usage:
# 1. Create `manifest.yaml` in the result directory.
# 2. Activate the analysis environment.
# 3. bash scripts/analysis.sh RESULTS_DIRECTORY
#
# Example:
#     (after creating and editing ../results/paper/manifest.yaml)
#     conda activate ./env
#     bash scripts/analysis.sh ../results/paper/manifest.yaml
#     ls ../results/paper/manifest/

MANIFEST="$1"
DIR="${MANIFEST%.*}"
FIGURE_DATA="$DIR/figure_data.json"
COMPARISON_OUTPUT="$DIR/comparison/"
TABLE_OUTPUT="$DIR/results_single_table.tex"
STATS_OUTPUT="$DIR/stats_tests/"

mkdir -p $DIR
cp table.tex $DIR

python -m src.analysis.figures collect "$MANIFEST" --output "$FIGURE_DATA"
python -m src.analysis.figures comparison --figure_data "$FIGURE_DATA" --output "$COMPARISON_OUTPUT"

python -m src.analysis.figures comparison \
  --figure_data "$FIGURE_DATA" \
  --output "$DIR/comparison_split" \
  --plot-solo False \
  --groups "[['2D LP (Sphere)', '10D LP (Sphere)', '2D LP (Rastrigin)', '10D LP (Rastrigin)'], ['2D LP (Flat)', '10D LP (Flat)', 'Arm Repertoire'], ['TA (MNIST)', 'TA (F-MNIST)', 'LSI (Hiker)']]"
  # --groups "[['2D LP (Sphere)', '10D LP (Sphere)'], ['2D LP (Rastrigin)', '10D LP (Rastrigin)'], ['2D LP (Flat)', '10D LP (Flat)'], ['Arm Repertoire', 'TA (MNIST)'], ['TA (F-MNIST)', 'LSI (Hiker)']]"

# 10000 lines up with CMA-MAE paper.
python -m src.analysis.figures single_table \
  --figure_data "$FIGURE_DATA" \
  --iteration=10000 \
  --output "$TABLE_OUTPUT" \
  --show_std False
(cd $DIR && pdflatex "table.tex")

# python -m src.analysis.figures table \
#   --figure_data "$FIGURE_DATA" \
#   --output "$DIR/results_table.tex" \
#   --transpose False

python -m src.analysis.figures single_table \
  --figure_data "$FIGURE_DATA" \
  --iteration=10000 \
  --output "$DIR/results_split_table.tex" \
  --show_std True \
  --table-groups "[['2D LP (Sphere)', '10D LP (Sphere)', '2D LP (Rastrigin)', '10D LP (Rastrigin)'], ['2D LP (Flat)', '10D LP (Flat)', 'Arm Repertoire'], ['TA (MNIST)', 'TA (F-MNIST)', 'LSI (Hiker)']]"
  # --table-groups "[['2D LP (Sphere)', '10D LP (Sphere)'], ['2D LP (Rastrigin)', '10D LP (Rastrigin)'], ['2D LP (Flat)', '10D LP (Flat)'], ['Arm Repertoire', 'TA (MNIST)'], ['TA (F-MNIST)', 'LSI (Hiker)']]"
  # --table-groups "[['2D LP (Sphere)'], ['10D LP (Sphere)'], ['2D LP (Rastrigin)'], ['10D LP (Rastrigin)'], ['2D LP (Flat)'], ['10D LP (Flat)'], ['Arm Repertoire'], ['TA (MNIST)'], ['TA (F-MNIST)'], ['LSI (Hiker)']]"

python -m src.analysis.figures tests \
  --figure_data "$FIGURE_DATA" \
  --output "$STATS_OUTPUT" \
  --table-groups "[['2D LP (Sphere)', '10D LP (Sphere)', '2D LP (Rastrigin)', '10D LP (Rastrigin)', '2D LP (Flat)', '10D LP (Flat)'], ['Arm Repertoire', 'TA (MNIST)', 'TA (F-MNIST)', 'LSI (Hiker)']]"
