#!/bin/bash
DOMAIN="triangles_mnist"
NAME="cma_mae_triangles_fashion_mnist"

# TQDM is disabled to hopefully help speed up the jobs by preventing them from
# competing for stdout.
TQDM_DISABLE=1 python -m src.discrete_qd --multirun hydra/launcher=joblib \
  hydra.launcher.n_jobs=1 \
  hydra.job.name="$NAME" \
  hydra.sweep.dir="'./logs/$NAME/\${now:%Y-%m-%d_%H-%M-%S}'" \
  hydra.sweep.subdir="'\${hydra:job.num}__\${hydra:runtime.choices.domain}_restart=\${algo._emitter_dict.e1.type.args.restart_rule}_lr=\${algo.archive.args.learning_rate}_seed=\${seed}'" \
  domain="${DOMAIN}" \
  algo=cma_mae \
  algo/archive=cvt_fashion_1000_mae \
  algo/result_archive=cvt_fashion_1000 \
  algo._emitter_dict.e1.type.args.restart_rule=50 \
  algo.archive.args.learning_rate=0.1 \
  itrs=10000 \
  eval=standard \
  eval/archive=cvt_fashion_1000 \
  seed=$(python scripts/seeds.py 5)
