#!/bin/bash
DOMAIN=lsi_clip_2d
NAME="map_elites_${DOMAIN}"

# TQDM is disabled to hopefully help speed up the jobs by preventing them from
# competing for stdout.
TQDM_DISABLE=1 python -m src.discrete_qd --multirun hydra/launcher=joblib \
  hydra.launcher.n_jobs=1 \
  hydra.job.name="$NAME" \
  hydra.sweep.dir="'./logs/$NAME/\${now:%Y-%m-%d_%H-%M-%S}'" \
  hydra.sweep.subdir="'\${hydra:job.num}__\${hydra:runtime.choices.domain}_seed=\${seed}'" \
  domain="${DOMAIN}" \
  algo=map_elites \
  algo/archive=grid_200 \
  itrs=10000 \
  eval=standard_uniform \
  seed=$(python scripts/seeds.py 5)
