"""Creates and saves centroids for the CVTArchive.

Usage:
    python -m src.cvt.make_centroids \
        domain=flat_multi_100d \
        eval/archive=cvt_multi_100d
"""
import logging

import hydra
import numpy as np
from omegaconf import DictConfig, OmegaConf

from src.utils.hydra_utils import define_resolvers
from src.utils.logging import setup_logdir_from_hydra

log = logging.getLogger(__name__)


@hydra.main(version_base=None, config_path="../../config", config_name="config")
def main(cfg: DictConfig):
    """Runs experiment."""
    define_resolvers()

    logdir = setup_logdir_from_hydra()
    log.info(f"Logging directory: {logdir.logdir}")

    archive_cfg = cfg.eval.archive
    OmegaConf.set_struct(archive_cfg, False)

    centroid_file = archive_cfg.pop("centroid_file")

    log.info(f"Centroid File: {centroid_file}")

    archive = hydra.utils.instantiate(archive_cfg, solution_dim=0, seed=42)

    np.save(centroid_file, archive.centroids)


if __name__ == '__main__':
    main()  # pylint: disable = no-value-for-parameter
