This is a simple library for training graph neural networks on various datasets. It was used for the paper "Characterizing Graph Datasets for Node Classification: Homophily-Heterophily Dichotomy and Beyond".

To use this library, you first need to install dependencies provided in environment.yml.

###1. Computing metrics

In the paper we propose a number of metrics for characterizing graph datasets. The code for computing these metrics (with examples) is available in notebooks/characterizing_labeled_graphs.ipynb.

###2. Experiments

Below we describe how to reproduce experiments from Section 4.3 of the paper.

To generate synthetic graphs run generate.py.

To run experiments run one of the following scripts:

- scripts/experiments_GCN.sh
- scripts/experiments_SAGE.sh
- scripts/experiments_GAT.sh
- scripts/experiments_GT.sh

To visualize results use one of the following notebooks:

- notebooks/results_GCN.ipynb
- notebooks/results_SAGE.ipynb
- notebooks/results_GAT.ipynb
- notebooks/results_GT.ipynb
