import os
from os import listdir

import magic
import numpy as np
from secml.array import CArray
from secml.testing import CUnitTest

from secml_malware.models import CClassifierEnd2EndMalware, MalConv, CClassifierEmber
from secml_malware.models.c_classifier_sorel_net import CClassifierSorel


class BlackBoxBaseTests(CUnitTest):
	def setUp(self):

		self.max_length = 2 ** 20
		self.padding_value = 256
		self.root_module_path = os.path.dirname(
			os.path.dirname(os.path.dirname(__file__))
		)
		self.end2end_classifier = CClassifierEnd2EndMalware(MalConv())
		self.end2end_classifier.load_pretrained_model()

		self.ember_classifier = CClassifierEmber(os.path.join(self.root_module_path, "../data/trained/ember_model.txt"))

		self.sorel_net_classifier = CClassifierSorel(
			model_path=os.path.join(self.root_module_path, "../data/trained/sorel_dnn_model.pth"),
			use_tags=False, use_counts=False)

		self.malware_folder = os.path.join(
			self.root_module_path, "../data/malware_samples/test_folder"
		)
		self.goodware_folder = os.path.join(
			self.root_module_path, "../data/goodware_samples/"
		)
		self.single_malware_path = os.path.join(
			self.root_module_path, "../data/malware_samples/test_malware"
		)
		X_ember = []
		y = []
		for f in listdir(self.malware_folder):
			complete_path = os.path.join(self.malware_folder, f)
			if not os.path.isfile(complete_path):
				continue
			if "PE32" not in magic.from_file(complete_path): continue
			with open(complete_path, "rb") as malware:
				print(f'>Using {f}')
				byte_malware = malware.read()
				X_ember.append(byte_malware)
			y.append(1)
		max_length = max([len(i) for i in X_ember])
		X_ember_carray = []
		for x in X_ember:
			padded_vector = (np.zeros(max_length) + 256).astype(np.int)
			int_x = np.frombuffer(x, dtype=np.uint8)
			padded_vector[:len(x)] = int_x
			X_ember_carray.append(padded_vector)
		self.X = CArray(X_ember_carray)
		self.Y = CArray(y)
