# Multi-Segmental Informational Coding for Self-Supervised Representation Learning

This is a Pytorch implementation of the paper.


## Installation
Assuming [Anaconda](https://www.anaconda.com/) with python 3.8, a step-by-step example for installing this project is as follows:

```shell script
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=10.2 -c pytorch
conda install matplotlib
```

## Pretrain on ImageNet

```shell script
sbatch job_music.sh  # need to adjust according to your computing platform
```

## Linear Evaluation on ImageNet

```shell script
python linear_eval.py
```

## Visualization

Our pretrained models can be downloaded [here](https://drive.google.com/drive/folders/1YLR2k8GY15v9qjgrS4s-sD9ZXTQZ5IJM?usp=share_link)

```shell script
python visualize_matrix.py  # visualize the joint probability matrix
```

```shell script
python visualize_samples.py  # visualize samples assigned to specific feature units
```

## CIFAR10

```shell script
python music_cifar.py  # pretrain
```

```shell script
python linear_eval_cifar.py  # linear evaluation
```