
class ComponentProcess:
    def __init__(self, process_name, isObserved, surrogate_A, surrogate_B, close_observed_effect_set=set(), who_offer_surrogate_A = None):
        self.process_name = process_name              #save the name of this component process
        self.isObserved = isObserved        #bool value
        self.surrogate_A = surrogate_A      #save the instance of one measured surrogate
        self.surrogate_B = surrogate_B      #save the instance of another measured surrogate
        self.direct_effects = []            #list of instances, save all children,include pure children and impure children. In this version of the algorithm, we careless about the intermediate latent processes between direct cause and effect.
        self.direct_causes = []             #list of instances, save all parents
        self.close_observed_effect_set = close_observed_effect_set      #set() # set of close observed effect set, used for getting sibling set later. Initally for observed processes set as themself, then when new latent process adding direct effects.  
        self.who_offer_surrogate_A = who_offer_surrogate_A  #save the instance 
    
    
    def observed_initialize_set_who_offer_surrogate_A(self, who_offer_surrogate_A):
        self.who_offer_surrogate_A = who_offer_surrogate_A
    
    def get_who_offer_surrogate_A(self):
        return self.who_offer_surrogate_A
    
    def get_process_name(self):
        return self.process_name
    
    def get_isObserved(self):
        return self.isObserved
    
    def get_close_observed_effect_set(self):
        return self.close_observed_effect_set
    
    def add_close_observed_effect_set(self, direct_effect):
        if not self.isObserved:
            self.close_observed_effect_set.update(direct_effect.get_close_observed_effect_set())
    
    def observed_initialize_close_observed_effect_set(self, process):
        if self.isObserved:
            self.close_observed_effect_set = set([process])
    
    def get_surrogate_A(self):
        return self.surrogate_A
    
    def observed_initialize_surrogate_A(self, process):
        self.surrogate_A = process
    
    def observed_initialize_surrogate_B(self, process):
        self.surrogate_B = process
    
    def get_direct_effects(self):
        return self.direct_effects
    
    def add_direct_effect(self, direct_effect):
        if direct_effect not in self.direct_effects:
            self.direct_effects.append(direct_effect)
            # if not self.isObserved:
            #     self.add_close_observed_effect_set(direct_effect)
            
    
    # def remove_direct_effect(self, direct_effect):
    #     if direct_effect in self.direct_effects:
    #         self.direct_effects.remove(direct_effect) 
    
    
    def get_direct_causes(self):
        return self.direct_causes
    
    def add_direct_cause(self, direct_cause):
        if direct_cause not in self.direct_causes:
            self.direct_causes.append(direct_cause)  
    
    # def remove_direct_cause(self, direct_cause):
    #     if direct_cause in self.direct_causes:
    #         self.direct_causes.remove(direct_cause) 
    
    
    
    
