import pandas as pd


def generate_lagged_time_series(data, lags):
    """
    Generate time series data for each considered time lag term.

    Parameters:
    data (pd.DataFrame): A pandas DataFrame where each column represents a process (time series).
    lags (list of int): A list of time lags to consider (e.g., [0, 1, 2, 3]).

    Returns:
    pd.DataFrame: A new DataFrame containing the original time series and their lagged terms.
    """
    
    # Collect lagged columns in a dictionary
    lagged_columns = {}
    columns = data.columns
    for column in columns:
        for lag in lags:
            lagged_columns[f"{column}_lag_{lag}"] = data[column].shift(lag)
    # Combine original data with new lagged columns using pd.concat
    lagged_data = pd.DataFrame(lagged_columns)

    # Drop rows with NaN values introduced by lagging
    lagged_data.dropna(inplace=True)
    
    return lagged_data






def merge_list_modified(list_of_lists):
    merged_lists = list_of_lists.copy()
    
    # Repeat the merging process until no more overlaps can be merged
    while True:
        new_merged_lists = []
    
        for sublist in merged_lists:
            merged = False
            for existing_list in new_merged_lists:
                if any(item in existing_list for item in sublist):
                    existing_list.extend(item for item in sublist if item not in existing_list)
                    merged = True
                    break
            if not merged:
                new_merged_lists.append(sublist)
    
        # If no changes were made in this pass, break the loop
        if len(new_merged_lists) == len(merged_lists):
            break

        merged_lists = new_merged_lists  # Update merged lists for the next iteration

    return merged_lists
    
