import pydot
from ComponentProcess import ComponentProcess
import time


def get_current_time():
    current_time = time.strftime('%Y-%m-%d_%H-%M-%S', time.localtime())
    return current_time

#draw Pyramid-shaped graph
def Make_mergedPyramid_graph(allKnownCompProcesses: list):
    graph = pydot.Dot(graph_type='digraph')

    for process in allKnownCompProcesses:
        name = process.get_process_name()
        graph.add_node(pydot.Node(name, label = name))

    for process in allKnownCompProcesses:
        for effect in process.get_direct_effects():
            graph.add_edge(pydot.Edge(process.get_process_name(), effect.get_process_name()))
        
    current_time = get_current_time()
    graph.write_png(f"plots/merged_pyramid_graph_{current_time}.png")          
    graph.write_dot('plots/merged_pyramid_graph.dot')
    
