
import os
import json
import argparse
import numpy as np
from PIL import Image, ImageDraw,ImageFont

import torch
from torchvision.ops import nms
from pocket.data import HICODet
hico_verb_object_list = [('board', 'airplane'),
 ('direct', 'airplane'),
 ('exit', 'airplane'),
 ('fly', 'airplane'),
 ('inspect', 'airplane'),
 ('load', 'airplane'),
 ('ride', 'airplane'),
 ('sit on', 'airplane'),
 ('wash', 'airplane'),
 ('no interaction', 'airplane'),
 ('carry', 'bicycle'),
 ('hold', 'bicycle'),
 ('inspect', 'bicycle'),
 ('jump', 'bicycle'),
 ('hop on', 'bicycle'),
 ('park', 'bicycle'),
 ('push', 'bicycle'),
 ('repair', 'bicycle'),
 ('ride', 'bicycle'),
 ('sit on', 'bicycle'),
 ('straddle', 'bicycle'),
 ('walk', 'bicycle'),
 ('wash', 'bicycle'),
 ('no interaction', 'bicycle'),
 ('chase', 'bird'),
 ('feed', 'bird'),
 ('hold', 'bird'),
 ('pet', 'bird'),
 ('release', 'bird'),
 ('watch', 'bird'),
 ('no interaction', 'bird'),
 ('board', 'boat'),
 ('drive', 'boat'),
 ('exit', 'boat'),
 ('inspect', 'boat'),
 ('jump', 'boat'),
 ('launch', 'boat'),
 ('repair', 'boat'),
 ('ride', 'boat'),
 ('row', 'boat'),
 ('sail', 'boat'),
 ('sit on', 'boat'),
 ('stand on', 'boat'),
 ('tie', 'boat'),
 ('wash', 'boat'),
 ('no interaction', 'boat'),
 ('carry', 'bottle'),
 ('drink with', 'bottle'),
 ('hold', 'bottle'),
 ('inspect', 'bottle'),
 ('lick', 'bottle'),
 ('open', 'bottle'),
 ('pour', 'bottle'),
 ('no interaction', 'bottle'),
 ('board', 'bus'),
 ('direct', 'bus'),
 ('drive', 'bus'),
 ('exit', 'bus'),
 ('inspect', 'bus'),
 ('load', 'bus'),
 ('ride', 'bus'),
 ('sit on', 'bus'),
 ('wash', 'bus'),
 ('wave', 'bus'),
 ('no interaction', 'bus'),
 ('board', 'car'),
 ('direct', 'car'),
 ('drive', 'car'),
 ('hose', 'car'),
 ('inspect', 'car'),
 ('jump', 'car'),
 ('load', 'car'),
 ('park', 'car'),
 ('ride', 'car'),
 ('wash', 'car'),
 ('no interaction', 'car'),
 ('dry', 'cat'),
 ('feed', 'cat'),
 ('hold', 'cat'),
 ('hug', 'cat'),
 ('kiss', 'cat'),
 ('pet', 'cat'),
 ('scratch', 'cat'),
 ('wash', 'cat'),
 ('chase', 'cat'),
 ('no interaction', 'cat'),
 ('carry', 'chair'),
 ('hold', 'chair'),
 ('lie on', 'chair'),
 ('sit on', 'chair'),
 ('stand on', 'chair'),
 ('no interaction', 'chair'),
 ('carry', 'couch'),
 ('lie on', 'couch'),
 ('sit on', 'couch'),
 ('no interaction', 'couch'),
 ('feed', 'cow'),
 ('herd', 'cow'),
 ('hold', 'cow'),
 ('hug', 'cow'),
 ('kiss', 'cow'),
 ('lasso', 'cow'),
 ('milk', 'cow'),
 ('pet', 'cow'),
 ('ride', 'cow'),
 ('walk', 'cow'),
 ('no interaction', 'cow'),
 ('clean', 'dining table'),
 ('eat at', 'dining table'),
 ('sit at', 'dining table'),
 ('no interaction', 'dining table'),
 ('carry', 'dog'),
 ('dry', 'dog'),
 ('feed', 'dog'),
 ('groom', 'dog'),
 ('hold', 'dog'),
 ('hose', 'dog'),
 ('hug', 'dog'),
 ('inspect', 'dog'),
 ('kiss', 'dog'),
 ('pet', 'dog'),
 ('run', 'dog'),
 ('scratch', 'dog'),
 ('straddle', 'dog'),
 ('train', 'dog'),
 ('walk', 'dog'),
 ('wash', 'dog'),
 ('chase', 'dog'),
 ('no interaction', 'dog'),
 ('feed', 'horse'),
 ('groom', 'horse'),
 ('hold', 'horse'),
 ('hug', 'horse'),
 ('jump', 'horse'),
 ('kiss', 'horse'),
 ('load', 'horse'),
 ('hop on', 'horse'),
 ('pet', 'horse'),
 ('race', 'horse'),
 ('ride', 'horse'),
 ('run', 'horse'),
 ('straddle', 'horse'),
 ('train', 'horse'),
 ('walk', 'horse'),
 ('wash', 'horse'),
 ('no interaction', 'horse'),
 ('hold', 'motorcycle'),
 ('inspect', 'motorcycle'),
 ('jump', 'motorcycle'),
 ('hop on', 'motorcycle'),
 ('park', 'motorcycle'),
 ('push', 'motorcycle'),
 ('race', 'motorcycle'),
 ('ride', 'motorcycle'),
 ('sit on', 'motorcycle'),
 ('straddle', 'motorcycle'),
 ('turn', 'motorcycle'),
 ('walk', 'motorcycle'),
 ('wash', 'motorcycle'),
 ('no interaction', 'motorcycle'),
 ('carry', 'person'),
 ('greet', 'person'),
 ('hold', 'person'),
 ('hug', 'person'),
 ('kiss', 'person'),
 ('stab', 'person'),
 ('tag', 'person'),
 ('teach', 'person'),
 ('lick', 'person'),
 ('no interaction', 'person'),
 ('carry', 'potted plant'),
 ('hold', 'potted plant'),
 ('hose', 'potted plant'),
 ('no interaction', 'potted plant'),
 ('carry', 'sheep'),
 ('feed', 'sheep'),
 ('herd', 'sheep'),
 ('hold', 'sheep'),
 ('hug', 'sheep'),
 ('kiss', 'sheep'),
 ('pet', 'sheep'),
 ('ride', 'sheep'),
 ('shear', 'sheep'),
 ('walk', 'sheep'),
 ('wash', 'sheep'),
 ('no interaction', 'sheep'),
 ('board', 'train'),
 ('drive', 'train'),
 ('exit', 'train'),
 ('load', 'train'),
 ('ride', 'train'),
 ('sit on', 'train'),
 ('wash', 'train'),
 ('no interaction', 'train'),
 ('control', 'tv'),
 ('repair', 'tv'),
 ('watch', 'tv'),
 ('no interaction', 'tv'),
 ('buy', 'apple'),
 ('cut', 'apple'),
 ('eat', 'apple'),
 ('hold', 'apple'),
 ('inspect', 'apple'),
 ('peel', 'apple'),
 ('pick', 'apple'),
 ('smell', 'apple'),
 ('wash', 'apple'),
 ('no interaction', 'apple'),
 ('carry', 'backpack'),
 ('hold', 'backpack'),
 ('inspect', 'backpack'),
 ('open', 'backpack'),
 ('wear', 'backpack'),
 ('no interaction', 'backpack'),
 ('buy', 'banana'),
 ('carry', 'banana'),
 ('cut', 'banana'),
 ('eat', 'banana'),
 ('hold', 'banana'),
 ('inspect', 'banana'),
 ('peel', 'banana'),
 ('pick', 'banana'),
 ('smell', 'banana'),
 ('no interaction', 'banana'),
 ('break', 'baseball bat'),
 ('carry', 'baseball bat'),
 ('hold', 'baseball bat'),
 ('sign', 'baseball bat'),
 ('swing', 'baseball bat'),
 ('throw', 'baseball bat'),
 ('wield', 'baseball bat'),
 ('no interaction', 'baseball bat'),
 ('hold', 'baseball glove'),
 ('wear', 'baseball glove'),
 ('no interaction', 'baseball glove'),
 ('feed', 'bear'),
 ('hunt', 'bear'),
 ('watch', 'bear'),
 ('no interaction', 'bear'),
 ('clean', 'bed'),
 ('lie on', 'bed'),
 ('sit on', 'bed'),
 ('no interaction', 'bed'),
 ('inspect', 'bench'),
 ('lie on', 'bench'),
 ('sit on', 'bench'),
 ('no interaction', 'bench'),
 ('carry', 'book'),
 ('hold', 'book'),
 ('open', 'book'),
 ('read', 'book'),
 ('no interaction', 'book'),
 ('hold', 'bowl'),
 ('stir', 'bowl'),
 ('wash', 'bowl'),
 ('lick', 'bowl'),
 ('no interaction', 'bowl'),
 ('cut', 'broccoli'),
 ('eat', 'broccoli'),
 ('hold', 'broccoli'),
 ('smell', 'broccoli'),
 ('stir', 'broccoli'),
 ('wash', 'broccoli'),
 ('no interaction', 'broccoli'),
 ('blow', 'cake'),
 ('carry', 'cake'),
 ('cut', 'cake'),
 ('eat', 'cake'),
 ('hold', 'cake'),
 ('light', 'cake'),
 ('make', 'cake'),
 ('pick up', 'cake'),
 ('no interaction', 'cake'),
 ('carry', 'carrot'),
 ('cook', 'carrot'),
 ('cut', 'carrot'),
 ('eat', 'carrot'),
 ('hold', 'carrot'),
 ('peel', 'carrot'),
 ('smell', 'carrot'),
 ('stir', 'carrot'),
 ('wash', 'carrot'),
 ('no interaction', 'carrot'),
 ('carry', 'cell phone'),
 ('hold', 'cell phone'),
 ('read', 'cell phone'),
 ('repair', 'cell phone'),
 ('talk on', 'cell phone'),
 ('text on', 'cell phone'),
 ('no interaction', 'cell phone'),
 ('check', 'clock'),
 ('hold', 'clock'),
 ('repair', 'clock'),
 ('set', 'clock'),
 ('no interaction', 'clock'),
 ('carry', 'cup'),
 ('drink with', 'cup'),
 ('hold', 'cup'),
 ('inspect', 'cup'),
 ('pour', 'cup'),
 ('sip', 'cup'),
 ('smell', 'cup'),
 ('fill', 'cup'),
 ('wash', 'cup'),
 ('no interaction', 'cup'),
 ('buy', 'donut'),
 ('carry', 'donut'),
 ('eat', 'donut'),
 ('hold', 'donut'),
 ('make', 'donut'),
 ('pick up', 'donut'),
 ('smell', 'donut'),
 ('no interaction', 'donut'),
 ('feed', 'elephant'),
 ('hold', 'elephant'),
 ('hose', 'elephant'),
 ('hug', 'elephant'),
 ('kiss', 'elephant'),
 ('hop on', 'elephant'),
 ('pet', 'elephant'),
 ('ride', 'elephant'),
 ('walk', 'elephant'),
 ('wash', 'elephant'),
 ('watch', 'elephant'),
 ('no interaction', 'elephant'),
 ('hug', 'fire hydrant'),
 ('inspect', 'fire hydrant'),
 ('open', 'fire hydrant'),
 ('paint', 'fire hydrant'),
 ('no interaction', 'fire hydrant'),
 ('hold', 'fork'),
 ('lift', 'fork'),
 ('stick', 'fork'),
 ('lick', 'fork'),
 ('wash', 'fork'),
 ('no interaction', 'fork'),
 ('block', 'frisbee'),
 ('catch', 'frisbee'),
 ('hold', 'frisbee'),
 ('spin', 'frisbee'),
 ('throw', 'frisbee'),
 ('no interaction', 'frisbee'),
 ('feed', 'giraffe'),
 ('kiss', 'giraffe'),
 ('pet', 'giraffe'),
 ('ride', 'giraffe'),
 ('watch', 'giraffe'),
 ('no interaction', 'giraffe'),
 ('hold', 'hair drier'),
 ('operate', 'hair drier'),
 ('repair', 'hair drier'),
 ('no interaction', 'hair drier'),
 ('carry', 'handbag'),
 ('hold', 'handbag'),
 ('inspect', 'handbag'),
 ('no interaction', 'handbag'),
 ('carry', 'hot dog'),
 ('cook', 'hot dog'),
 ('cut', 'hot dog'),
 ('eat', 'hot dog'),
 ('hold', 'hot dog'),
 ('make', 'hot dog'),
 ('no interaction', 'hot dog'),
 ('carry', 'keyboard'),
 ('clean', 'keyboard'),
 ('hold', 'keyboard'),
 ('type on', 'keyboard'),
 ('no interaction', 'keyboard'),
 ('assemble', 'kite'),
 ('carry', 'kite'),
 ('fly', 'kite'),
 ('hold', 'kite'),
 ('inspect', 'kite'),
 ('launch', 'kite'),
 ('pull', 'kite'),
 ('no interaction', 'kite'),
 ('cut with', 'knife'),
 ('hold', 'knife'),
 ('stick', 'knife'),
 ('wash', 'knife'),
 ('wield', 'knife'),
 ('lick', 'knife'),
 ('no interaction', 'knife'),
 ('hold', 'laptop'),
 ('open', 'laptop'),
 ('read', 'laptop'),
 ('repair', 'laptop'),
 ('type on', 'laptop'),
 ('no interaction', 'laptop'),
 ('clean', 'microwave'),
 ('open', 'microwave'),
 ('operate', 'microwave'),
 ('no interaction', 'microwave'),
 ('control', 'mouse'),
 ('hold', 'mouse'),
 ('repair', 'mouse'),
 ('no interaction', 'mouse'),
 ('buy', 'orange'),
 ('cut', 'orange'),
 ('eat', 'orange'),
 ('hold', 'orange'),
 ('inspect', 'orange'),
 ('peel', 'orange'),
 ('pick', 'orange'),
 ('squeeze', 'orange'),
 ('wash', 'orange'),
 ('no interaction', 'orange'),
 ('clean', 'oven'),
 ('hold', 'oven'),
 ('inspect', 'oven'),
 ('open', 'oven'),
 ('repair', 'oven'),
 ('operate', 'oven'),
 ('no interaction', 'oven'),
 ('check', 'parking meter'),
 ('pay', 'parking meter'),
 ('repair', 'parking meter'),
 ('no interaction', 'parking meter'),
 ('buy', 'pizza'),
 ('carry', 'pizza'),
 ('cook', 'pizza'),
 ('cut', 'pizza'),
 ('eat', 'pizza'),
 ('hold', 'pizza'),
 ('make', 'pizza'),
 ('pick up', 'pizza'),
 ('slide', 'pizza'),
 ('smell', 'pizza'),
 ('no interaction', 'pizza'),
 ('clean', 'refrigerator'),
 ('hold', 'refrigerator'),
 ('move', 'refrigerator'),
 ('open', 'refrigerator'),
 ('no interaction', 'refrigerator'),
 ('hold', 'remote'),
 ('point', 'remote'),
 ('swing', 'remote'),
 ('no interaction', 'remote'),
 ('carry', 'sandwich'),
 ('cook', 'sandwich'),
 ('cut', 'sandwich'),
 ('eat', 'sandwich'),
 ('hold', 'sandwich'),
 ('make', 'sandwich'),
 ('no interaction', 'sandwich'),
 ('cut with', 'scissors'),
 ('hold', 'scissors'),
 ('open', 'scissors'),
 ('no interaction', 'scissors'),
 ('clean', 'sink'),
 ('repair', 'sink'),
 ('wash', 'sink'),
 ('no interaction', 'sink'),
 ('carry', 'skateboard'),
 ('flip', 'skateboard'),
 ('grind', 'skateboard'),
 ('hold', 'skateboard'),
 ('jump', 'skateboard'),
 ('pick up', 'skateboard'),
 ('ride', 'skateboard'),
 ('sit on', 'skateboard'),
 ('stand on', 'skateboard'),
 ('no interaction', 'skateboard'),
 ('adjust', 'skis'),
 ('carry', 'skis'),
 ('hold', 'skis'),
 ('inspect', 'skis'),
 ('jump', 'skis'),
 ('pick up', 'skis'),
 ('repair', 'skis'),
 ('ride', 'skis'),
 ('stand on', 'skis'),
 ('wear', 'skis'),
 ('no interaction', 'skis'),
 ('adjust', 'snowboard'),
 ('carry', 'snowboard'),
 ('grind', 'snowboard'),
 ('hold', 'snowboard'),
 ('jump', 'snowboard'),
 ('ride', 'snowboard'),
 ('stand on', 'snowboard'),
 ('wear', 'snowboard'),
 ('no interaction', 'snowboard'),
 ('hold', 'spoon'),
 ('lick', 'spoon'),
 ('wash', 'spoon'),
 ('sip', 'spoon'),
 ('no interaction', 'spoon'),
 ('block', 'sports ball'),
 ('carry', 'sports ball'),
 ('catch', 'sports ball'),
 ('dribble', 'sports ball'),
 ('hit', 'sports ball'),
 ('hold', 'sports ball'),
 ('inspect', 'sports ball'),
 ('kick', 'sports ball'),
 ('pick up', 'sports ball'),
 ('serve', 'sports ball'),
 ('sign', 'sports ball'),
 ('spin', 'sports ball'),
 ('throw', 'sports ball'),
 ('no interaction', 'sports ball'),
 ('hold', 'stop sign'),
 ('stand under', 'stop sign'),
 ('stop at', 'stop sign'),
 ('no interaction', 'stop sign'),
 ('carry', 'suitcase'),
 ('drag', 'suitcase'),
 ('hold', 'suitcase'),
 ('hug', 'suitcase'),
 ('load', 'suitcase'),
 ('open', 'suitcase'),
 ('pack', 'suitcase'),
 ('pick up', 'suitcase'),
 ('zip', 'suitcase'),
 ('no interaction', 'suitcase'),
 ('carry', 'surfboard'),
 ('drag', 'surfboard'),
 ('hold', 'surfboard'),
 ('inspect', 'surfboard'),
 ('jump', 'surfboard'),
 ('lie on', 'surfboard'),
 ('load', 'surfboard'),
 ('ride', 'surfboard'),
 ('stand on', 'surfboard'),
 ('sit on', 'surfboard'),
 ('wash', 'surfboard'),
 ('no interaction', 'surfboard'),
 ('carry', 'teddy bear'),
 ('hold', 'teddy bear'),
 ('hug', 'teddy bear'),
 ('kiss', 'teddy bear'),
 ('no interaction', 'teddy bear'),
 ('carry', 'tennis racket'),
 ('hold', 'tennis racket'),
 ('inspect', 'tennis racket'),
 ('swing', 'tennis racket'),
 ('no interaction', 'tennis racket'),
 ('adjust', 'tie'),
 ('cut', 'tie'),
 ('hold', 'tie'),
 ('inspect', 'tie'),
 ('pull', 'tie'),
 ('tie', 'tie'),
 ('wear', 'tie'),
 ('no interaction', 'tie'),
 ('hold', 'toaster'),
 ('operate', 'toaster'),
 ('repair', 'toaster'),
 ('no interaction', 'toaster'),
 ('clean', 'toilet'),
 ('flush', 'toilet'),
 ('open', 'toilet'),
 ('repair', 'toilet'),
 ('sit on', 'toilet'),
 ('stand on', 'toilet'),
 ('wash', 'toilet'),
 ('no interaction', 'toilet'),
 ('brush with', 'toothbrush'),
 ('hold', 'toothbrush'),
 ('wash', 'toothbrush'),
 ('no interaction', 'toothbrush'),
 ('install', 'traffic light'),
 ('repair', 'traffic light'),
 ('stand under', 'traffic light'),
 ('stop at', 'traffic light'),
 ('no interaction', 'traffic light'),
 ('direct', 'truck'),
 ('drive', 'truck'),
 ('inspect', 'truck'),
 ('load', 'truck'),
 ('repair', 'truck'),
 ('ride', 'truck'),
 ('sit on', 'truck'),
 ('wash', 'truck'),
 ('no interaction', 'truck'),
 ('carry', 'umbrella'),
 ('hold', 'umbrella'),
 ('lose', 'umbrella'),
 ('open', 'umbrella'),
 ('repair', 'umbrella'),
 ('set', 'umbrella'),
 ('stand under', 'umbrella'),
 ('no interaction', 'umbrella'),
 ('hold', 'vase'),
 ('make', 'vase'),
 ('paint', 'vase'),
 ('no interaction', 'vase'),
 ('fill', 'wine glass'),
 ('hold', 'wine glass'),
 ('sip', 'wine glass'),
 ('toast', 'wine glass'),
 ('lick', 'wine glass'),
 ('wash', 'wine glass'),
 ('no interaction', 'wine glass'),
 ('feed', 'zebra'),
 ('hold', 'zebra'),
 ('pet', 'zebra'),
 ('watch', 'zebra'),
 ('no interaction', 'zebra')]
object_name=['person', 'bicycle', 'car', 'motorcycle', 'airplane', 'bus', 'train', 'truck', 'boat', 'traffic_light', 'fire_hydrant', 'stop_sign', 'parking_meter',
             'bench', 'bird', 'cat', 'dog', 'horse', 'sheep', 'cow', 'elephant', 'bear', 'zebra', 'giraffe', 'backpack', 'umbrella', 'handbag',
             'tie', 'suitcase', 'frisbee', 'skis', 'snowboard', 'sports_ball', 'kite', 'baseball_bat', 'baseball_glove', 'skateboard', 'surfboard',
             'tennis_racket', 'bottle', 'wine_glass', 'cup', 'fork', 'knife', 'spoon', 'bowl', 'banana', 'apple', 'sandwich', 'orange', 'broccoli',
             'carrot', 'hot_dog', 'pizza', 'donut', 'cake', 'chair', 'couch', 'potted_plant', 'bed', 'dining_table', 'toilet', 'tv', 'laptop', 'mouse',
             'remote', 'keyboard', 'cell_phone', 'microwave', 'oven', 'toaster', 'sink', 'refrigerator', 'book', 'clock', 'vase', 'scissors', 'teddy_bear',
             'hair_drier', 'toothbrush']




def convert_coordinates(original_coords, original_size, target_size):

 original_width, original_height = original_size


 target_width, target_height = target_size


 x1, y1, x2, y2 = original_coords

 width_scale = target_width / original_width
 height_scale = target_height / original_height


 new_x1 = int(x1 * width_scale)
 new_y1 = int(y1 * height_scale)
 new_x2 = int(x2 * width_scale)
 new_y2 = int(y2 * height_scale)

 return [float(new_x1), float(new_y1), float(new_x2), float(new_y2)]



original_coordinates = [0, 115, 14, 178]  #
original_image_size = (224, 224)  #
target_image_size = (640, 480)  #




def visualize(args):
    # Set up root directory
    partition = args.partition
    dataset = HICODet(None, os.path.join(
        args.data_root, 'instances_{}.json'.format(args.partition)
    ))
    # Set up image instance path
    # image_name = dataset.filename(args.image_idx)
    image_name ='HICO_test2015_00000510.jpg'
    print("Image name: ", image_name)
    image_path = os.path.join(
        args.data_root,
        'hico_20160224_det/images/{}'.format(args.partition),
        image_name
    )
    detection_path = os.path.join(
        args.detection_root,
        image_name.replace('.jpg', '.json')
    )
    # Load image instance
    image = Image.open(image_path)
    with open(detection_path, 'r') as f:
        detections = json.load(f)
    # Remove low-scoring boxes
    box_score_thresh = args.box_score_thresh

    boxes = np.asarray(detections['boxes'])
    # print(boxes)
    scores = np.asarray(detections['scores'])
    labels=np.asarray(detections['labels'])
    hois=np.asarray(detections['hois'])
    # print(scores)
    keep_idx = np.where(scores >= box_score_thresh)[0]
    # print(keep_idx)
    boxes = boxes[keep_idx, :]
    # print(boxes)
    scores = scores[keep_idx]
    # Perform NMS
    keep_idx = nms(
        torch.from_numpy(boxes),
        torch.from_numpy(scores),
        args.nms_thresh
    )
    boxes = boxes[keep_idx]
    print('1',boxes)
    scores = scores[keep_idx]
    labels=labels[keep_idx]

    # Draw boxes
    # image=image.resize((224,224))
    canvas = ImageDraw.Draw(image)
    font_size = 20
    font = ImageFont.truetype("arial.ttf", font_size)
    for idx in range(boxes.shape[0]):
        coords = boxes[idx, :].tolist()
        canvas.rectangle(coords)
        # if idx>=8 :
        #      canvas.text(coords[:2] + [10, 5], 'table', font=font)
        canvas.text(coords[:2]+[10,5], object_name[labels[idx]],font=font)
    for idx,i in enumerate(hois):
        hoi_name=hico_verb_object_list[i][0]+' '+hico_verb_object_list[i][1]
        canvas.text((10.0,20*idx+10.0),hoi_name,fill= (255, 0, 0),font=font )

    image.show()

if __name__ == '__main__':

    parser = argparse.ArgumentParser(description="Visualize object detections")
    parser.add_argument('--detection-root', default='./test2015_gt', type=str)
    parser.add_argument('--image-idx', type=int, default=0)
    parser.add_argument('--data-root', type=str, default='./datasets')
    parser.add_argument('--partition', type=str, default='test2015')
    parser.add_argument('--box-score-thresh', type=float, default=0.2)
    parser.add_argument('--nms-thresh', type=float, default=0.5)
    args = parser.parse_args()

    visualize(args)
