#!/bin/bash

data='PACS'

for t in `seq 0 4`
do
  for domain in `seq 0 3`
  do
    CUDA_VISIBLE_DEVICES=0,1,2,3 python -m torch.distributed.launch --nproc_per_node=4 --master_port=29100 --use_env main_dg.py \
    --model vim_tiny_patch16_stride8_224_bimambav2_final_pool_mean_abs_pos_embed_with_midclstok_div2 \
    --batch-size 16 \
    --data $data \
    --target $domain \
    --seed $t \
    --data_root "/data/DataSets/" \
    --lr 5e-6 \
    --min-lr 1e-5 \
    --warmup-lr 1e-5 \
    --drop-path 0.0 \
    --weight-decay 1e-8 \
    --num_workers 16 \
    --output_dir ./output/vim_tiny \
    --epochs 50 \
    --finetune /data/gjt/Mamba/Vim_for_DG/vim/pretrained_models/vim_t_midclstok_ft_78p3acc.pth \
    --no_amp \
    --Vim_START_flag 2
  done
done

