import argparse
import enum


class ArgsType(enum.IntEnum):
    STATS_TEST = enum.auto()
    LIKELIHOOD_ANALYSIS = enum.auto()
    REWARD_LEARNING = enum.auto()


def parse_args(arg: ArgsType) -> argparse.Namespace:
    parser = argparse.ArgumentParser(description="Prescriptive Effort")

    #use_synth_prefs
    parser.add_argument(
        "--follow_up_study",
        action='store_true',
        help="If true, loads data from follow up study where we only change the preference elicitation instruction given to annotators",
    )

    parser.add_argument(
        "--conditions",
        type=str,
        default="Privileged-Control, Pr-Privileged, Regret-Privileged",
        help="The conditions to run analysis for seperated by commas. The options are [Privileged-Control, Pr-Privileged, Regret-Privileged, Trained-Control, Pr-Trained, Regret-Trained, Question-Control, Pr-Question, Regret-Question]",
    )

    if arg == ArgsType.STATS_TEST:
       
        parser.add_argument(
            "--control_group",
            type=str,
            default="NO_STATS_TRAINING_UI",
            help="Default condition for eliciting human prefs. Use NO_STATS_TRAINING_UI if condition=REGRET_TRAINING_UI or PR_TRAINING_UI. Otherwise use NO_STATS_UI.",
        )

        parser.add_argument(
            "--n_partitions",
            default="3,10,18,30,56,100",
            type=str,
            help="A delimited list containing the number of partitions to split the preference dataset into and perform analysis.",
        )


        parser.add_argument(
            "--p_threshold_1",
            default=100,
            type=int,
            help="Threshold for likelihood ratio test 1.",
        )

        parser.add_argument(
            "--p_threshold_2",
            default=10,
            type=int,
            help="Threshold for likelihood ratio test 2.",
        )
    if arg == ArgsType.LIKELIHOOD_ANALYSIS:

        #use_synth_prefs
        parser.add_argument(
            "--use_synth_prefs",
            action='store_true',
            help="If true, loads synthetic prefs generated by the model corrosponding to args.condition. If false, loads human preferences.",
        )

        parser.add_argument(
            "--mode",
            type=str,
            default="stoch",
            help="Whether to use deterministic or stochastically labeled synthetic prefs. Onle used if args.use_synth_prefs is true. Options are [stoch, det]",
        )

        parser.add_argument(
            "--lr",
            default=0.05,
            type=float,
            help="The learning rate used for fitting the Logistic Regression model to the preference dataset.",
        )

        parser.add_argument(
            "--n_epochs",
            default=10000,
            type=int,
            help="The number of epochs used for fitting the Logistic Regression model to the preference dataset.",
        )

        parser.add_argument(
            "--n_folds",
            default=10,
            type=int,
            help="The number of folds used for k-folds evaluation.",
        )

        parser.add_argument(
            "--pref_model",
            type=str,
            help="The preference model used to evaluate the likelihood of the dataset.",
        )
    
    if arg == ArgsType.REWARD_LEARNING:

    
        parser.add_argument(
            "--N_ITERS",
            default=5000,
            type=int,
            help="The iterations to train the reward model for.",
        )

        parser.add_argument(
            "--LR",
            default=0.5,
            type=float,
            help="The learning rate used to train the reward model.",
        )

        parser.add_argument(
            "--mode",
            type=str,
            default="det",
            help="Whether to use deterministic or stochastically labeled synthetic prefs if use_synth_prefs is set to true. Onle used if args.use_synth_prefs is true. Options are [stoch, det]",
        )

        parser.add_argument(
            "--expirement",
            type=str,
            default="TRAINED",
            help="Which of the 3 expirements to load in segment pairs from (PRIVILEGED, TRAINED, QUESTION)",
        )

        


        parser.add_argument(
            "--use_synth_prefs",
            action="store_true",
            default=False,
            help="Use synthetic prefs instead of human ones",
        )

        parser.add_argument(
            "--force_cpu",
            action="store_true",
            default=False,
            help="Force torch.device to CPU (use when running on Mastadon cluster)",
        )

        parser.add_argument(
            "--gamma",
            default=1.0,
            type=float,
            help="The discount rate.",
        )


        

    parser.add_argument(
        "--condition",
        default="REGRET_TRAINING_UI",
        type=str,
        help="The pref. model condition shown to workers while eliciting their preferences. The options are REGRET_TRAINING_UI or PR_TRAINING_UI for nudging human prefs. towards the regret or partial return model respactively. Additionally, use REGRET_UI or PR_UI for showing humans the ground truth regret or partial return info. at pref. elicition time.",
    )

    args = parser.parse_args()

    return args

