import os
import shutil
import argparse

def move_matching_files(method_dirs, target_base_dir):
    subfolders = ['TP', 'TN', 'FP', 'FN']
    
    for subfolder in subfolders:
        # Create full paths for each subfolder in all method directories
        paths = [os.path.join(method_dir, subfolder) for method_dir in method_dirs]
        target_paths = [os.path.join(target_base_dir, os.path.basename(method_dir), subfolder) for method_dir in method_dirs]

        # Ensure target directories exist
        for target_path in target_paths:
            os.makedirs(target_path, exist_ok=True)
        
        # List all files in each directory and find matching files
        matching_files = None
        for path in paths:
            files = set(os.listdir(path))
            if matching_files is None:
                matching_files = files
            else:
                matching_files = matching_files.intersection(files)
        
        # Move matching files to respective target directories
        for file_name in matching_files:
            for path, target_path in zip(paths, target_paths):
                shutil.copy(os.path.join(path, file_name), os.path.join(target_path, file_name))
                print(f"Copied {file_name} to {target_path}")

def main():
    parser = argparse.ArgumentParser(description='Move matching files across multiple methods.')
    parser.add_argument('--methods', nargs='+', required=True, help='List of method directories to compare.')
    parser.add_argument('--target_dir', type=str, required=True, help='Base target directory to store matching files.')
    
    args = parser.parse_args()
    
    move_matching_files(args.methods, args.target_dir)

if __name__ == '__main__':
    main()


# rm -rf htmls_*/; python xai_extract_similar_samples.py --methods ../../../visualization/htmls_COT ../../../visualization/htmls_POS ../../../visualization/htmls_NO_XAI --target_dir ../../../xai_study/llm-judge/scripts/
