>📋  A  README.md for code accompanying for the submission of NeuRIPs ID: 937

# My Paper Title

This repository is the official implementation of [NeuRIPs_ID_937](https://arxiv.org/abs/*********). 



## Requirements

To install requirements:

```setup
pip install -e .
```

For training, you need to further install additional dependencies as follows:

```shell
pip install -e ".[train]"
pip install flash_attn --no-build-isolation
```

To get IQA Datasets:

1. LIVE: https://live.ece.utexas.edu/research/quality/subjective.htm
2. CSIQ: https://qualinet.github.io/databases/image/categorical_image_quality_csiq_database/
3. KADID-10k: https://database.mmsp-kn.de/kadid-10k-database.html
4. BID: https://drive.google.com/drive/folders/1Qmtp-Fo1iiQiyf-9uRUpO-YAAM0mcIey
5. LIVE Challenge: https://live.ece.utexas.edu/research/ChallengeDB/
7. TID2013: https://www.ponomarenko.info/tid2013.htm
8. SPAQ: https://github.com/h4nwei/SPAQ
9. AGIQA-3K: https://github.com/lcysyzxdxc/AGIQA-3k-Database

>📋  All the dataset should place to the path of "/playground/data/". It is worth noting that the name of dataset should keep in **lowcase**.

## Training

To train the model(s) in the paper, run this command:

```train
sh scripts/iqa_mix.sh
```

>📋  This process requires seven NVIDIA A40 (48G) GPUs to meet the computational load. After training, the checkpoint will save to the root path with a new folder with the name **NeuRIPs-937**

## Inference

To evaluate my model on all nine IQA dataset descirbe above, run:

```eval
python Compare2Score/evaluate/compare2score_eval.py --model-path NeuRIPs-937
```

>📋  Using the above commands, it will automatic generate the inference results on the nine dataset. It worth noting that the inference can be conducted on the device with single NVIDIA RTX3090 (24G) GPU.


