# Discretized Quadratic Integrate-And-Fire Neuron Model For Direct Training Of Spiking Neural Networks

## Requirements

### Anaconda

If you're using anaconda, we recommend creating an environment by running the command

```bash
conda create -n "SNN" python=3.12
```

### Installing Requirements

After creating your environment, run

```bash
pip install -r requirements.txt
```

## Our Experimental Setup

Our experimental system had the following setup

- CPU: Intel-12600k
- GPU: RTX 3090
- 64 GBs of RAM
- OS: Ubuntu 23.04.

## Recreating Results

To recreate the results found in our work, we have included a bash script, `run.sh`, which contains the exact command line arguments we used for our experiments.

Once you uncomment a specific experiment you would like to run, use the command

```bash
./run.sh
```

Additionally, the seed used for each model can be changed. For our three experiments, we used seeds `42`, `43`, and `44`. During the training process, all required data is automatically saved for further analysis.

For additional commands, one can run

```bash
python3 main.py --help
```

## Recreating Figures

Once you have trained models, the `Graphs` directory contains various Jupyter notebooks which we used to generate the figures and statistics for our work. To use these notebooks, simply direct the notebook to the appropriate folder containing training results. Some notebooks require the user to additionally add information such as which training files belong to a LIF or QIF model.

- `Graphs/Experiments` includes the required code to graph the training results of each model.
- `Graphs/LossLandscape` includes notebooks to generate the loss landscape comparisons between the QIF and LIF neuron models.
- `Graphs/Robustness` includes the notebook required to generate the hyperparameter robustness analysis. Additionally, this folder contains two json files detailing the hyperparameters used to generate the data. These can be iterated through to regenerate the data.
- `Graphs/SpikeRateEnergyConsumption` includes the notebooks required to analysis the spike rate and energy consumption of each model using the QIF and LIF neuron models.

## Additional Notes

Several neuromorphic datasets, which are managed by SpikingJelly and Tonic, require the user to follow specific directions from these packages in order to download and process these datasets. Additionally, we include the training data for all of our models. However, due to storage limitations, we do not include the trained model weights.