import torch

def decode_max(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the maximum of the tensor.

    Args:
        x (torch.Tensor): The input tensor.
        
    Returns:    
        torch.Tensor: The maximum of the input.
    """
    return torch.max(x, 0).values

def decode_mean(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the mean of the tensor.

    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The mean of the input.
    """
    return torch.mean(x, 0)

def decode_last(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the last element of the tensor.
    
    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The last element of the input.
    """
    return x[-1]

def decode_first(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the first element of the tensor.
    
    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The first element of the input.
    """
    return x[0]

def decode_sum(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the sum of the tensor.
    
    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The sum of input across time.
    """
    return torch.sum(x, 0)

def decode_same(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the same tensor.
    
    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The input tensor.
    """
    return x.squeeze(0)

def decode_identity(x: torch.Tensor) -> torch.Tensor:
    """
    Decode the identity of the network.
    
    Args:
        x (torch.Tensor): The input tensor.
    
    Returns:    
        torch.Tensor: The input tensor.
    """
    return x

if __name__ == "__main__":
    x = torch.rand(10, 1, 10)

    print(f"Max: {decode_max(x)}")
    print(f"Mean: {decode_mean(x)}")
    print(f"Last: {decode_last(x)}")
    print(f"Sum: {decode_sum(x)}")
    print(f"Same: {decode_same(x)}")
    print(f"Identity: {decode_identity(x)}")
