import torch
import random

def roll(interval: int = 10):
    """
    Roll the data tensor by a random amount in the x and y directions.

    Args:
        data: The data tensor to roll.
            - Shape: (Time, batch size, channels, height, width)
        interval: The maximum amount to roll the data tensor in the x and y directions.
    """
    def roll_(data: torch.Tensor):
        """
        Roll the data tensor by a random amount in the x and y directions.

        Args:
            data: The data tensor to roll.
                - Shape: (Time, batch size, channels, height, width)
            interval: The maximum amount to roll the data tensor in the x and y directions.
        """
        off1 = random.randint(-interval, interval)
        off2 = random.randint(-interval, interval)
        return torch.roll(data, shifts=(off1, off2), dims=(2, 3))
    return roll_
