from .Rectangle import rectangle_fn
from .AsymRectangle import asym_rectangle_fn

from norse.torch.functional.threshold import threshold as norse_threshold

import torch

def threshold(x: torch.Tensor, method: str = "super", alpha: float = 0.01, beta: float | None = None) -> torch.Tensor:
    if method in ["heaviside", "super", "triangle", "tanh", "circ", "heavi_erfc"]:
        return norse_threshold(x, method=method, alpha=alpha)
    elif method == "rectangle":
        return rectangle_fn(x, alpha)
    elif method == "asym_rectangle":
        return asym_rectangle_fn(x, alpha, beta)
    else:
        raise NotImplementedError(f"Threshold method {method} not implemented.")
    

    
