#!/bin/bash

# Arrays for beta and u_th values
betas=(0.2 0.4 0.6 0.8 1.0)
u_ths=(0.2 0.4 0.6 0.8 1.0)
as=(0.2 0.4 0.6 0.8 1.0)
u_cs=(0.2 0.4 0.6 0.8 1.0)

# Loop through beta and u_th values
for beta in "${betas[@]}"; do
    for u_th in "${u_ths[@]}"; do
        # Construct the command
        name="ITLIF_DVSGesture_beta_${beta}_u_th_${u_th}"

        python3 main.py \
            --dataset dvsgesture \
            --model itlifdvsgesturenet \
            --loss crossentropy \
            --sg asym_rectangle \
            --encoder identity \
            --batch_size 32 \
            --epochs 20 \
            --optimizer adam \
            --lr 0.001 \
            --l2 1e-4 \
            --num_workers 8 \
            --scheduler cosine \
            --name "$name" \
            --checkpoint 25 \
            --seed 42
    done
done

for a in "${as[@]}"; do
    for u_c in "${u_cs[@]}"; do
        for u_th in "${u_ths[@]}"; do
            # Construct the command
            name="ITQIF_DVSGesture_a_${a}_u_c_${u_c}_u_th_${u_th}"
            python3 main.py \
                --dataset dvsgesture \
                --model itqifdvsgesturenet \
                --loss crossentropy \
                --sg asym_rectangle \
                --encoder identity \
                --batch_size 32 \
                --epochs 20 \
                --optimizer adam \
                --lr 0.001 \
                --l2 1e-4 \
                --num_workers 8 \
                --scheduler cosine \
                --name "$name" \
                --checkpoint 25 \
                --seed 42
        done
    done
done