#!/bin/bash

##############################################
# CIFAR-10 T = 2                             #
##############################################

# python3 main.py \
#     --dataset cifar10 \
#     --model itqifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --lr 0.1 \
#     --l2 1e-4 \
#     --nesterov True \
#     --momentum 0.9 \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --name "ITQIFResNet19_T2" \
#     --num_workers 6 \
#     --seed 42 \

# python3 main.py \
#     --dataset cifar10 \
#     --model itlifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --lr 0.001 \
#     --l2 1e-4 \
#     --nesterov True \
#     --momentum 0.9 \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --name "ITLIFResNet19_T2" \
#     --num_workers 6 \

##############################################
# CIFAR-10 T = 4                             #
##############################################

# python3 main.py \
#     --dataset cifar10 \
#     --model itqifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --lr 0.1 \
#     --l2 1e-4 \
#     --nesterov True \
#     --momentum 0.9 \
#     --scheduler cosine \
#     --seq_length 4 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --name "QIFResNet19_T4" \
#     --num_workers 6 \
#     --seed 42

##############################################
# CIFAR-100 T = 2                            #
##############################################

# python3 main.py \
#     --dataset cifar100 \
#     --model itqifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --momentum 0.9 \
#     --lr 0.1 \
#     --l2 1e-4 \
#     --nesterov True \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 64 \
#     --checkpoint 25 \
#     --num_workers 6 \
#     --name "QIFResNet19_CIFAR100_Cutout_autoaugment_T2" \
#     --seed 42

# python3 main.py \
#     --dataset cifar100 \
#     --model itlifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --momentum 0.9 \
#     --lr 1e-3 \
#     --l2 1e-4 \
#     --nesterov True \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --num_workers 6 \
#     --name "ITLIFResNet19_CIFAR100_Cutout_autoaugment" \
#     --seed 42

##############################################
# CIFAR-100 T = 4                            #
##############################################

# python3 main.py \
#     --dataset cifar100 \
#     --model itqifresnet19 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --momentum 0.9 \
#     --lr 0.1 \
#     --l2 1e-4 \
#     --nesterov True \
#     --scheduler cosine \
#     --seq_length 4 \
#     --batch_size 64 \
#     --checkpoint 25 \
#     --num_workers 6 \
#     --name "ITQIFResNet19_CIFAR100_Cutout_autoaugment_T4" \
#     --seed 42

##############################################
# CIFAR-10 T = 2                             #
##############################################

# python3 main.py \
#     --dataset cifar10 \
#     --model itqifresnet34 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer sgd \
#     --lr 0.1 \
#     --l2 1e-4 \
#     --nesterov True \
#     --momentum 0.9 \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --name "ITQIFResNet34_CIFAR10_T2" \
#     --num_workers 6 \
#     --seed 42 \
#     --load_weights "ITQIFResNet34_CIFAR10_T2_(2024-11-14)_(12-38-00)" \
#     --resume True \

# python3 main.py \
#     --dataset cifar10 \
#     --model itlifresnet34 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder copy \
#     --decode mean \
#     --epochs 350 \
#     --optimizer adamw \
#     --lr 0.01 \
#     --l2 1e-5 \
#     --scheduler cosine \
#     --seq_length 2 \
#     --batch_size 128 \
#     --checkpoint 25 \
#     --name "ITLIFResNet34_CIFAR10_T2" \
#     --num_workers 6 \
#     --seed 42 \
#     --load_weights "ITLIFResNet34_CIFAR10_T2_(2024-11-14)_(15-18-07)" \
#     --resume True \

##############################################
# SpikeFormer T = 2                          #
##############################################

python3 main.py \
    --dataset tinyimagenet \
    --model qifspikeformer \
    --loss crossentropy \
    --sg asym_rectangle \
    --encoder copy \
    --decode identity \
    --epochs 300 \
    --optimizer lamb \
    --lr 3e-4 \
    --l2 5e-2 \
    --scheduler cosine \
    --seq_length 2 \
    --batch_size 128 \
    --checkpoint 10 \
    --name "SpikeFormer_QIFResNet19_T2" \
    --num_workers 6 \
    --seed 42 \
    --load_weights "SpikeFormer_QIFResNet19_T2_(2024-11-19)_(21-02-47)" \
    --resume True 

python3 main.py \
    --dataset tinyimagenet \
    --model lifspikeformer \
    --loss crossentropy \
    --sg asym_rectangle \
    --encoder copy \
    --decode identity \
    --epochs 300 \
    --optimizer lamb \
    --lr 3e-4 \
    --l2 5e-2 \
    --scheduler cosine \
    --seq_length 2 \
    --batch_size 128 \
    --checkpoint 10 \
    --name "SpikeFormer_LIFResNet19_T2" \
    --num_workers 6 \
    --seed 42 \
    --load_weights "SpikeFormer_LIFResNet19_T2_(2024-11-20)_(00-40-09)" \
    --resume True 

##############################################
# N-Caltech-101 T = 4                        #
##############################################

# python3 main.py \
#     --dataset ncaltech101 \
#     --model itqifvgg11 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 200 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --name "ITQIFVGG11_NCaltech101_NDA_LOW_200" \
#     --checkpoint 25 \
#     --scheduler cosine \
#     --cutmix True \
#     --seed 42

# python3 main.py \
#     --dataset ncaltech101 \
#     --model itlifvgg11 \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 200 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --name "LIFVGG11_NCaltech101_NDA_LOW_200" \
#     --checkpoint 25 \
#     --scheduler cosine \
#     --cutmix True

##############################################
# N-Caltech-101 T = 10                       #
##############################################

# CIFAR-10 DVS

# python3 main.py \
#     --dataset cifar10dvs \
#     --model itqifvggsnn \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 5e-4 \
#     --num_workers 8 \
#     --checkpoint 10 \
#     --scheduler cosine \
#     --name "ITQIFVGGSNN_Dropout_Cosine_Augmentations_100" \
#     --seed 42

# python3 main.py \
#     --dataset cifar10dvs \
#     --model ITlifvggsnn \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 5e-4 \
#     --num_workers 8 \
#     --checkpoint 10 \ 
#     --scheduler cosine \
#     --name "ITLIFVGGSNN_Dropout_Cosine_Augmentations_100"

##############################################
# N-Cars T = 10                              #
##############################################

# python3 main.py \
#     --dataset ncars \
#     --model itqifvggsnn \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --checkpoint 25 \
#     --scheduler cosine \
#     --name "ITQIFVGGSNN_NCars" \
#     --seq_length 10 \
#     --seed 42

# python3 main.py \
#     --dataset ncars \
#     --model itlifvggsnn \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 64 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 1e-3 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --checkpoint 25 \
#     --scheduler cosine \
#     --name "ITLIFVGGSNN_NCars"

##############################################
# DVS128-Gesture T = 10                      #
##############################################

# python3 main.py \
#     --dataset dvsgesture \
#     --model itqifdvsgesturenet \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 32 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 0.001 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --scheduler cosine \
#     --name "ITQIFVGGSNN_DVSGesture" \
#     --checkpoint 25 \
#     --seed 42

# python3 main.py \
#     --dataset dvsgesture \
#     --model lifdvsgesturenet \
#     --loss crossentropy \
#     --sg asym_rectangle \
#     --encoder identity \
#     --batch_size 32 \
#     --epochs 100 \
#     --optimizer adam \
#     --lr 0.001 \
#     --l2 1e-4 \
#     --num_workers 8 \
#     --scheduler cosine \
#     --name "LIFVGGSNN_DVSGesture" \
#     --checkpoint 25