import numpy as np
from math import *
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import sys, random, time
from mpl_toolkits.axes_grid1.inset_locator import zoomed_inset_axes
from mpl_toolkits.axes_grid1.inset_locator import mark_inset
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

MERIT_mean=np.array(np.loadtxt("MERIT_return_sto_mean_file.txt",dtype=float))
MERIT_sd=np.array(np.loadtxt("MERIT_return_sto_std_file.txt",dtype=float))
IT_mean=np.array(np.loadtxt("MERIT_return_det_mean_file.txt",dtype=float))
IT_sd=np.array(np.loadtxt("MERIT_return_det_std_file.txt",dtype=float))
naive_MERIT_mean=np.array(np.loadtxt("IT_return_sto_mean_file.txt",dtype=float))
naive_MERIT_sd=np.array(np.loadtxt("IT_return_sto_std_file.txt",dtype=float))
naive_IT_mean=np.array(np.loadtxt("IT_return_det_mean_file.txt",dtype=float))
naive_IT_sd=np.array(np.loadtxt("IT_return_det_std_file.txt",dtype=float))
hindsight_mean=np.array([1.0]*141)
hindsight_sd=np.array([0.0]*141)
expert_mean=np.array([1.0]*141)
expert_sd=np.array([0.0]*141)
MERIT_mean = MERIT_mean[0:141]
MERIT_sd = MERIT_sd[0:141]
IT_mean = IT_mean[0:141]
IT_sd = IT_sd[0:141]
naive_MERIT_mean = naive_MERIT_mean[0:141]
naive_MERIT_sd = naive_MERIT_sd[0:141]
naive_IT_mean = naive_IT_mean[0:141]
naive_IT_sd = naive_IT_sd[0:141]

plt.rcParams.update({'font.size': 14})
axis=np.arange(0,141,1)

fig, ax = plt.subplots()
ax.plot(axis,MERIT_mean,label='MERIT-IRL')
ax.fill_between(axis,MERIT_mean-MERIT_sd,MERIT_mean+MERIT_sd,alpha=0.2)
ax.plot(axis,IT_mean,label='IT-IRL')
ax.fill_between(axis,IT_mean-IT_sd,IT_mean+IT_sd,alpha=0.2)
ax.plot(axis,naive_MERIT_mean,label='naive MERIT-IRL')
ax.fill_between(axis,naive_MERIT_mean-naive_MERIT_sd,naive_MERIT_mean+naive_MERIT_sd,alpha=0.2)
ax.plot(axis,naive_IT_mean,label='naive IT-IRL')
ax.fill_between(axis,naive_IT_mean-naive_IT_sd,naive_IT_mean+naive_IT_sd,alpha=0.2)
#ax.plot(axis,hindsight_mean)
#ax.fill_between(axis,hindsight_mean-hindsight_sd,hindsight_mean+hindsight_sd,alpha=0.2)
#ax.plot(axis,expert_mean,label='Expert')
#ax.fill_between(axis,expert_mean-expert_sd,expert_mean+expert_sd,alpha=0.2)

plt.xticks(np.arange(0,141,20))
plt.xlabel('Observed time steps (t)')
plt.legend()
plt.show()





