
from __future__ import annotations

import _pickle as cPickle
from pathlib import Path

import matplotlib.pyplot as plt
import numpy as np
import pandas as pd


def main():
    # get results
    files = list(Path().glob("*.pickle"))
    files.sort()

    # metric names
    var_names = [
        "MSE",
        "normalized MSE",
        "Conservation MSE",
        "Maximum Error",
        "MSE at boundary",
        "MSE FT low",
        "MSE FT mid",
        "MSE FT high",
    ]

    # define index
    index1, index2, index3 = [], [], []
    for _j, fl in enumerate(files):
        with Path(fl).open("rb") as f:
            title = str(fl).split("/")[-1][:-7].split("_")
            index1.append(title[0] + title[1])
            index2.append(title[2]+ title[3])
            index3.append(title[4] + title[5])
    indexes = [index1, index2, index3]

    # create dataframe
    data = np.zeros([len(files), 8])
    for j, fl in enumerate(files):
        with Path(fl).open("rb") as f:
            test = cPickle.load(f)
            for i, var in enumerate(test):
                if i == 5:
                    data[j, i:] = var
                else:
                    data[j, i] = var

    index = pd.MultiIndex.from_arrays(indexes, names=("PDE", "param", "model"))
    data = pd.DataFrame(data, columns=var_names, index=index)
    data.to_csv("Results.csv")


if __name__ == "__main__":
    main()
