"""Script to compile results."""

import pandas as pd
from joblib import Parallel, delayed
from glob import glob
from configs.path_configs import path_configs


def compile_results(linked=False):
    result_base_dir = (
        path_configs["results"] / "llm_kg_comparison_linked"
        if linked
        else path_configs["results"] / "llm_kg_comparison"
    )
    save_path = (
        path_configs["results"] / "compiled_results" / "result_comparison_linked.csv"
        if linked
        else path_configs["results"] / "compiled_results" / "result_comparison.csv"
    )
    result_list = glob(f"{result_base_dir}/*/score/*.csv*")
    df_score_ = Parallel(n_jobs=-1)(delayed(pd.read_csv)(args) for args in result_list)
    df_score = pd.concat(df_score_, axis=0)
    df_score.reset_index(drop=True, inplace=True)

    print("Method counts:")
    print(df_score.method.value_counts())
    df_score.to_csv(save_path, index=False)
    return


if __name__ == "__main__":
    compile_results(linked=True)
    compile_results(linked=False)
