"""Configurations required for the experiments."""

import json
from pathlib import Path

from glob import glob
from configs.path_configs import path_configs


# Datasets
# Path of the folder containing data
data_folder = path_configs["data"]

# Configs
config_path = f"{data_folder}/data_configs.json"
filename = open(config_path)
data_config = json.load(filename)
filename.close()

data_list = list(data_config.keys())
data_list.sort()

carte_datasets = [data_name for data_name in data_list if "carte_" in data_name]
ttb_datasets = [data_name for data_name in data_list if "ttb_" in data_name]
wikidb_datasets = [data_name for data_name in data_list if "wdbs_" in data_name]

# Linked entity datasets
data_folder_le = path_configs["linked_ent_data_folder"]
data_list_linked = glob(f"{data_folder_le}/*/*")
data_list_linked = [x.split("/")[-1].split(".parquet")[0] for x in data_list_linked]
data_list_linked.sort()

# Baselines
preprocessors = []
estimators = ["ridge", "xgb"]
baselines = [p.name for p in path_configs["emb_data_folder"].iterdir() if p.is_dir()]
linked_baselines = [
    p.name for p in path_configs["emb_linked_data_folder"].iterdir() if p.is_dir()
]

# Visualization
