"""Configurations of the paths for the TabBack experiments."""

from pathlib import Path

# Get the base path
base_path = Path(__file__).resolve().parents[1]


path_configs = dict()
path_configs["base_path"] = base_path
path_configs["data"] = base_path / "data/tabular/processed"
path_configs["results"] = base_path / "results"

path_configs["linked_ent_data_folder"] = (
    base_path / "data/tabular/tables_with_linked_entities"
)
path_configs["emb_linked_data_folder"] = base_path / "models/linked"
path_configs["emb_data_folder"] = base_path / "models/unlinked"
path_configs["emb_cache_folder"] = base_path / "__cache__"
