import torch

def euclidean_dist(x, y, do_sqrt=False):
    # x: N x D
    # y: M x D
    n = x.size(0)
    m = y.size(0)
    d = x.size(1)
    assert d == y.size(1)

    x = x.unsqueeze(1).expand(n, m, d)
    y = y.unsqueeze(0).expand(n, m, d)
    if not do_sqrt:
        return torch.pow(x - y, 2).sum(2)
    else:
        return torch.sqrt(torch.pow(x - y, 2).sum(2))
