#! /bin/bash
python setup.py install
# modelname='bigprotonet_conv'
# data='cifar100' # miniimagenet
data='miniimagenet'
trainway=20
trainshot=10
trainquery=15 # number of instance per class in query set 
testway=10
testshot=0 # default=0, means using the same shot number as trainshot
testquery=15
lr=0.001
proto_lr=10

if [ ! -d results ]; then
    mkdir results
fi



for modelname in 'bigprotonet_conv' ;
do
savedir=results/$data-$modelname-$trainway-$trainshot-$testway-$testshot-seed0-$lr-$proto_lr-recenter-new
if [ ! -d $savedir ]; then
    mkdir $savedir
fi
# --model.x_dim 3,84,84 \
python -u scripts/train/few_shot/run_train.py \
--data.way $trainway \
--data.shot $trainshot \
--data.query $trainquery \
--data.test_way $testway \
--data.test_shot $testshot \
--data.test_query $testquery \
--data.cuda \
--model.model_name $modelname \
--log.exp_dir $savedir \
--train.patience 200 \
--model.x_dim 3,84,84 \
--data.dataset $data \
--train.learning_rate $lr \
--train.optim_method SGD \
--train.proto_optim_method Adam \
--train.proto_learning_rate $proto_lr \
--train.proto_weight_decay 0.0 \
--seed 0 > $savedir/log.log
done
# srun --gpus 1 python -u scripts/train/few_shot/run_train.py --data.way 30 --data.shot 1 --data.query 15 --data.test_way 5 --data.test_shot 0 --data.test_query 15  --data.cuda --model.model_name bigprotonet_conv --log.exp_dir bigproto_results
