# Code for BigPrototypes (beta)

- This is the code for ICLR 2022 submission "Few-shot Learning with Big Prototypes"

## Overview
- There are three folders, each corresponding to one task in the paper.
    - `CV` contains code for miniImageNet image classification task. It is modified on top of https://github.com/jakesnell/prototypical-networks
    - `NER` contains code for Few-NERD few-shot NER task. It is modified on top of https://github.com/thunlp/Few-NERD
    - `RE` contains code for FewRel 1.0 and 2.0 Domain Adaptation tasks. It is modified on top of https://github.com/thunlp/FewRel

## Project Structure
```
-- CV
|   -- data/miniimagenet-fewshot  # the readme file contains the download page for the data
|   -- protonets
|       -- data      # data utils
|       -- models    # implementation of prototypes and big prototypes
|       -- utils     # other utils
|   -- scripts       # training script
  
-- NER
|   -- data    
|   -- model
|       -- bigproto.py  # impelentation of big prototypes
|       -- proto.py     # implementation of prototypes
|   -- util
|   -- train_demo.py    # main training script

-- RE
|   -- fewshot_re_kit   # utils for training
|   -- models
|       -- bigproto.py  # impelentation of big prototypes
|       -- proto.py     # implementation of prototypes
|   -- train_demo.py    # main training script

```

## How to run
- We have provided Few-NERD data, running `sh run.sh` in `NER` folder will initiate the big prototypes training process on 5-way-5-shot INTER settings on Few-NERD.
- Relation Extraction data can be obtained in https://github.com/thunlp/FewRel. Since test dataset should not be distributed. A demo of big prototypes can be run with test on val data as follows in the `RE` folder
```
python -u train_demo.py --lr 0.001 --train_iter 20000 --val_step 1000 --val_iter 500 --encoder cnn --model bigproto  --proto_lr 0.1 --seed 0 --N 5 --K 5 --Q 5 --na_rate 0 --batch_size 1 --val val_wiki --test test_wiki
```
- For image classification task, data download page link is provided in `CV/data/miniimagenet-fewshot/readme.md` download miniimagenet data and unzip and rename them as
```
CV/data/miniimagenet-fewshot/mini-imagenet-cache-test.pkl
CV/data/miniimagenet-fewshot/mini-imagenet-cache-train.pkl
CV/data/miniimagenet-fewshot/mini-imagenet-cache-val.pkl
```
then running `sh train.sh` in `CV` folder will initiate training process of big prototypes with CNN encoders.