# Instructions to replicate our experiments

## 1. Setup a python environment
Create a new python 3 environment with the following packages installed:
- numpy (https://numpy.org/)
- scikit-learn (https://scikit-learn.org/stable/)
- matplotlib (https://matplotlib.org/)
- pandas (https://pandas.pydata.org/)

This can be accomplished using the conda package manager (https://docs.conda.io/en/latest/) with the following: 
```bash
conda create -n my_env
conda activate my_env
conda config --env --add channels conda-forge
conda install numpy scikit-learn matplotlib pandas tqdm -y
````
Then install pytorch using one of the recommended commands found here: https://pytorch.org/get-started/locally/. For example:
```bash
conda install pytorch torchvision torchaudio pytorch-cuda=11.8 -c pytorch -c nvidia
```

## Running the experiments
To run our experiments, execute the following under the conda environment created above. The results plots will be placed in the results folder. In the body of our paper we only show the row corresponding to a batch size of 1024.
```bash
python main.py run
python main.py plot
```
The results are in results/
<!-- show the picture in the results folder -->

Main Figure in paper:
![Paper results](results/paper_body_results.png "Results used in the paper")




