from .cifar10 import get_train_valid_test_loader as cifar10loader
from .cifar10 import get_datasets as cifar10datasets
from .cifar10 import get_transforms as cifar10transforms

from .cifar100 import get_train_valid_test_loader as cifar100loader
from .cifar100 import get_datasets as cifar100datasets
from .cifar100 import get_transforms as cifar100transforms


dataloader_dict = {
    "cifar10" : cifar10loader,
    "cifar100" : cifar100loader,
}

dataset_dict = {
    "cifar10" : cifar10datasets,
    "cifar100" : cifar100datasets,
}


dataset_nclasses_dict = {
    "cifar10" : 10,
    "cifar100" : 100,
}

dataset_classname_dict = {
    "cifar10" : ['airplane', 'automobile', 'bird', 'cat', 'deer', 'dog', 'frog', 'horse', 'ship', 'truck'],

    "cifar100" : ['apple', 'aquarium_fish', 'baby', 'bear', 'beaver', 'bed', 'bee', 'beetle', 
                'bicycle', 'bottle', 'bowl', 'boy', 'bridge', 'bus', 'butterfly', 'camel', 
                'can', 'castle', 'caterpillar', 'cattle', 'chair', 'chimpanzee', 'clock', 'cloud',
                'cockroach', 'couch', 'crab', 'crocodile', 'cup', 'dinosaur', 'dolphin',
                'elephant', 'flatfish', 'forest', 'fox', 'girl', 'hamster', 'house',
                'kangaroo', 'keyboard', 'lamp', 'lawn_mower', 'leopard', 'lion', 'lizard', 'lobster', 
                'man', 'maple_tree', 'motorcycle', 'mountain', 'mouse', 'mushroom', 'oak_tree', 'orange', 
                'orchid', 'otter', 'palm_tree', 'pear', 'pickup_truck', 'pine_tree', 'plain', 'plate',
                'poppy', 'porcupine', 'possum', 'rabbit', 'raccoon', 'ray', 'road', 'rocket',
                'rose', 'sea', 'seal', 'shark', 'shrew', 'skunk', 'skyscraper', 'snail',
                'snake', 'spider', 'squirrel', 'streetcar', 'sunflower', 'sweet_pepper', 'table', 'tank',
                'telephone', 'television', 'tiger', 'tractor', 'train', 'trout', 'tulip', 'turtle', 'wardrobe',
                'whale', 'willow_tree', 'wolf', 'woman', 'worm'],
}

dataset_transform_dict = {
    "cifar10" : cifar10transforms,
    "cifar100" : cifar100transforms,
}
