import numpy as np
from .frame_fg import *
import copy
from .frame_fg import FRAME_FUNC_INDEX

fragment_factory = ['c1ccccc1', 'NC=O', 'O=CO', 'c1ccncc1', 'c1ncc2nc[nH]c2n1', 'NS(=O)=O',
                   'O=P(O)(O)O', 'OCO', 'c1cncnc1','c1cn[nH]c1',
                   'O=P(O)O','c1ccc2ccccc2c1','c1ccsc1',
                   'N=CN','NC(N)=O','O=c1cc[nH]c(=O)[nH]1',
                   'c1ccc2ncccc2c1', 'c1cscn1', 'c1ccc2[nH]cnc2c1','c1c[nH]cn1',
                   'O=[N+][O-]', 'O=CNO', 'NC(=O)O','O=S=O','c1ccc2[nH]ccc2c1',]
single_atom = ['O', 'C', 'N', 'F', 'Cl', 'Br', 'S', 'I', 'P', 'B']
num_atom_types = len(single_atom) + 1
merge_c = ['C030', 'C020', 'C010', 'C040']
double_atom_split = ['CC', 'C=C', 'C=O','C#N', 'C#C']

motif_pos_fractory  = {'Others':[],
                    'c1ccccc1':[], 'NC=O':[], 'O=CO':[], 
                    'c1ccncc1':[], 'c1ncc2nc[nH]c2n1':[], 'NS(=O)=O':[],
                    'O=P(O)(O)O':[], 'OCO':[], 'c1cncnc1':[],'c1cn[nH]c1':[],
                    'O=P(O)O':[],'c1ccc2ccccc2c1':[],'c1ccsc1':[],
                    'N=CN':[],'NC(N)=O':[],'O=c1cc[nH]c(=O)[nH]1':[],
                    'c1ccc2ncccc2c1':[], 'c1cscn1':[], 'c1ccc2[nH]cnc2c1':[],
                    'c1c[nH]cn1':[], 'O=[N+][O-]':[], 'O=CNO':[], 'NC(=O)O':[],
                    'O=S=O':[],'c1ccc2[nH]ccc2c1':[]}
motif_record_raw = list(motif_pos_fractory.keys())

nso2_chirality1 = 'NS(=O)=O_1'
nso2_chirality1_pos = np.array([[ 1.6588922e+00, -6.0804268e-07,  5.9788363e-08],
                                [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                [-3.8918197e-01,  1.3683970e+00,  1.4697889e-08],
                                [-4.3756092e-01, -8.0007267e-01,  1.0797077e+00]])
ref_nso2_c1 = conf_with_smiles('NS(=O)=O', nso2_chirality1_pos.tolist())


nso2_chirality2 = 'NS(=O)=O_2'
nso2_chirality2_pos = np.array([[ 1.7030380e+00, -6.9371890e-07, -3.8107828e-10],
                                [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                [-5.1487333e-01,  1.3314996e+00,  2.6317764e-08],
                                [-5.7703251e-01, -4.6200401e-01, -1.2334596e+00]])
ref_nso2_c2 = conf_with_smiles('NS(=O)=O', nso2_chirality2_pos.tolist())


ocno_chirality1 = 'O=CNO_1'
ocno_chirality1_pos = np.array([[ 1.2190571e+00, -1.6208373e-06,  1.4538045e-08],
                                [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                [-8.8246638e-01,  9.7450632e-01,  1.2864348e-08],
                                [-2.1573081e+00,  5.0287992e-01, -6.4420722e-02]])
ref_ocno_c1 = conf_with_smiles('O=CNO', ocno_chirality1_pos.tolist())

ocno_chirality2 = 'O=CNO_2'
ocno_chirality2_pos = np.array([[ 1.2286675e+00, -1.1711154e-06,  4.2419686e-09],
                                [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                [-7.2246945e-01,  1.1311073e+00,  6.9548207e-09],
                                [ 1.0112406e-01,  2.2202938e+00,  1.7587334e-01]])
ref_ocno_c2 = conf_with_smiles('O=CNO', ocno_chirality2_pos.tolist())

motif_record = copy.deepcopy(motif_record_raw)
motif_record.remove('NS(=O)=O')
motif_record.remove('O=CNO')

motif_record.append(nso2_chirality1)
motif_record.append(nso2_chirality2)
motif_record.append(ocno_chirality1)
motif_record.append(ocno_chirality2)

fg2class_dict = {key: i for i, key in enumerate(motif_record)}
class2fg_dict = {i: val for i, val in enumerate(motif_record)}

max_num_heavyatoms = 15

num_fg_types = len(motif_record)

motif_pos_fractory = {key:[] for key in motif_record}
motif_pos_fractory['c1ccccc1'] = np.array([[ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [ 1.4240885e+00,  3.2211587e-06, -3.3623166e-09],
                                            [ 2.1135716e+00,  1.2386608e+00, -6.4423205e-09],
                                            [ 1.3997321e+00,  2.4507318e+00, -1.7551119e-03],
                                            [-1.7316423e-02,  2.4402189e+00,  1.9860952e-03],
                                            [-7.3666584e-01,  1.2096317e+00,  4.4099120e-03]])

motif_pos_fractory['c1ncc2nc[nH]c2n1'] = np.array([[ 1.5020185e+00, -2.3377581e+00,  6.4161294e-03],
                                                    [ 1.5448210e-01, -2.4254203e+00,  6.3124686e-03],
                                                    [-6.5072495e-01, -1.3295950e+00,  4.1664611e-03],
                                                    [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                                    [-3.9226124e-01,  1.2869059e+00, -9.5980605e-03],
                                                    [ 7.3466456e-01,  2.0470557e+00, -4.0619890e-03],
                                                    [ 1.8373545e+00,  1.2652516e+00,  7.1828481e-08],
                                                    [ 1.4695843e+00,  2.8624222e-06, -9.8541051e-09],
                                                    [ 2.1551018e+00, -1.1650884e+00,  1.2827838e-03]])

motif_pos_fractory['NC=O'] = np.array([[ 1.3342621e+00, -1.3039464e-06,  4.1004569e-08],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-6.6582835e-01,  1.0330945e+00,  9.5496944e-10]])
                                    
motif_pos_fractory['O=CO'] = np.array([[ 1.2248449e+00, -1.3015033e-06, -1.5363327e-08],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-6.8171293e-01,  1.0178998e+00,  4.0344048e-09]])

motif_pos_fractory['c1ccncc1'] = np.array([[ 1.37011969e+00,  2.39376855e+00,  1.33044785e-02],
                                            [ 2.06607842e+00,  1.18120992e+00,  4.58217319e-03],
                                            [ 1.34387732e+00, -1.14445652e-06, -9.25844290e-09],
                                            [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00],
                                            [-7.00914502e-01,  1.15587246e+00,  4.45180603e-08],
                                            [-1.73232500e-02,  2.36040950e+00,  8.59577022e-03]])

motif_pos_fractory['OCO'] = np.array([[ 1.4267797e+00, -7.9549136e-07,  3.0697720e-09],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-5.4514164e-01,  1.3195761e+00,  4.5638444e-09]])

motif_pos_fractory['NS(=O)=O_1'] = nso2_chirality1_pos
motif_pos_fractory['NS(=O)=O_2'] = nso2_chirality2_pos

motif_pos_fractory['O=P(O)(O)O'] = np.array([[ 1.5893636e+00, -6.3171228e-07, -2.4263954e-08],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [-4.7894573e-01,  1.4797467e+00,  3.5216544e-08],
                                            [-5.3230500e-01, -7.3022610e-01, -1.3084352e+00],
                                            [-5.6151181e-01, -7.7315265e-01,  1.2685354e+00]])

motif_pos_fractory['c1cncnc1'] = np.array([[ 1.5145210e+00,  2.4729097e+00,  2.6813976e-03],
                                            [ 2.1850412e+00,  1.1713032e+00,  3.9325543e-03],
                                            [ 1.3681470e+00, -8.1296116e-07, -2.6373543e-09],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [-5.9812105e-01,  1.2270370e+00, -5.8228187e-09],
                                            [ 8.9228414e-02,  2.4227960e+00, -3.0961825e-04]])
                                
motif_pos_fractory['c1cn[nH]c1'] = np.array([[ 4.0523776e-01,  2.2304873e+00, -3.2621799e-03],
                                            [-5.6663048e-01,  1.2727686e+00, -1.3783449e-08],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [ 1.3395047e+00, -7.9732285e-07, -1.6141882e-08],
                                            [ 1.9744844e+00,  1.5601634e+00, -9.0988548e-03]])

motif_pos_fractory['O=P(O)O'] = np.array([[ 1.5576512e+00, -1.1505417e-06, -1.1217253e-08],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [-3.2980326e-01,  7.9540849e-01,  1.3523443e+00],
                                            [-5.8177936e-01,  5.7761621e-01, -1.3523414e+00],
                                            [-4.5579131e-01,  6.8651235e-01,  1.4500000e-06]])

motif_pos_fractory['c1ccc2ccccc2c1'] = np.array([[ 1.54412305e+00, -2.42566204e+00,  1.41560715e-02],
                                                [ 2.12373185e+00, -1.18394232e+00,  3.58870625e-02],
                                                [ 1.40465021e+00, -1.07177857e-06,  4.26662154e-08],
                                                [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00],
                                                [-7.28550494e-01,  1.18119359e+00, -1.40062184e-08],
                                                [-2.13387179e+00,  1.06518233e+00,  3.23995315e-02],
                                                [-2.76921010e+00, -1.83482930e-01,  4.93016280e-02],
                                                [-2.01637530e+00, -1.34843826e+00,  3.16502526e-02],
                                                [-6.17347598e-01, -1.27447486e+00,  1.64936502e-02],
                                                [ 1.37279838e-01, -2.43728018e+00,  6.21971965e-04]])
                                            
motif_pos_fractory['c1ccsc1'] = np.array([[ 1.0164967e+00,  2.2223465e+00, -6.0588024e-03],
                                        [ 2.1212270e+00,  1.3226849e+00,  1.3081569e-04],
                                        [ 1.6782043e+00, -3.6027177e-07, -1.2872988e-08],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-2.6360339e-01,  1.6602657e+00,  1.2638338e-08]])

motif_pos_fractory['N=CN'] = np.array([[ 1.3017024e+00, -1.2857465e-06,  7.1369186e-09],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-7.2127104e-01,  1.0905267e+00,  4.0298573e-09]])   

motif_pos_fractory['NC(N)=O'] = np.array([[ 1.8868992e+00, -1.2696590e+00, -3.4172747e-03],
                                            [ 1.3645501e+00,  4.2852048e-06,  6.1336891e-09],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [ 2.0595088e+00,  9.9724209e-01,  2.9478201e-08]])  

motif_pos_fractory['O=c1cc[nH]c(=O)[nH]1'] = np.array([[ 2.0187006e+00, -1.0418707e+00,  1.4584361e-01],
                                                        [ 1.3934289e+00, -1.5675328e-06,  3.0231604e-09],
                                                        [ 1.9952943e+00,  1.2831430e+00, -1.8550850e-01],
                                                        [ 1.2166989e+00,  2.3572257e+00, -2.6154408e-01],
                                                        [-1.5913464e-01,  2.3015330e+00, -2.4406049e-01],
                                                        [-8.2882488e-01,  1.1066428e+00,  1.0077201e-09],
                                                        [-2.0480485e+00,  1.0099140e+00,  6.3092418e-02],
                                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00]])

motif_pos_fractory['c1ccc2ncccc2c1'] = np.array([[ 1.3935138e+00, -2.4145918e+00, -1.0479354e-02],
                                                [ 2.0949528e+00, -1.2083864e+00, -5.5506798e-03],
                                                [ 1.3944259e+00, -9.9278418e-07, -1.4673006e-08],
                                                [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                                [-6.3385123e-01,  1.1860133e+00, -2.5995305e-08],
                                                [-1.9745741e+00,  1.2596711e+00,  1.8347029e-02],
                                                [-2.7505300e+00,  9.7616576e-02,  9.9600153e-03],
                                                [-2.1245024e+00, -1.1483130e+00,  2.8943897e-03],
                                                [-7.1820021e-01, -1.2020283e+00,  8.7703671e-03],
                                                [-4.4168527e-03, -2.4101276e+00, -7.5139087e-03]])      

motif_pos_fractory['c1cscn1'] = np.array([[ 1.2278360e+00,  2.2702277e+00, -1.7526456e-03],
                                            [-5.1260591e-02,  1.7351604e+00, -4.0630382e-03],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [ 1.7148535e+00,  3.3378169e-06,  2.6033945e-08],
                                            [ 2.1962311e+00,  1.2527363e+00, -6.7744622e-08]])    

motif_pos_fractory['c1ccc2[nH]cnc2c1'] = np.array([[ 1.5251875e+00,  4.0114331e+00,  1.3904485e-02],
                                                    [ 2.7861328e+00,  3.3238072e+00,  1.5742850e-02],
                                                    [ 2.7466881e+00,  1.9067889e+00,  5.6191222e-03],
                                                    [ 1.5184653e+00,  1.3029400e+00,  6.8266282e-04],
                                                    [ 1.3276662e+00, -9.7461202e-07,  3.3128686e-08],
                                                    [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                                    [-5.9289843e-01,  1.1572580e+00, -2.1702704e-08],
                                                    [ 3.7167004e-01,  2.0006442e+00,  6.8632864e-05],
                                                    [ 3.0692232e-01,  3.3443043e+00,  3.2712501e-03]])  

motif_pos_fractory['c1c[nH]cn1'] = np.array([[ 6.8081367e-01,  2.0783560e+00,  3.3529854e-04],
                                            [ 1.7391207e+00,  1.2603132e+00, -3.9665755e-03],
                                            [ 1.3033508e+00, -7.1308841e-07,  4.5281467e-08],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [-4.2045051e-01,  1.1778128e+00, -4.0583359e-10]])          

motif_pos_fractory['O=[N+][O-]'] = np.array([[ 1.2286342e+00, -9.3281380e-07, -2.8104523e-08],
                                            [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                            [-6.0626364e-01,  1.1039269e+00, -9.4696020e-09]])      

motif_pos_fractory['O=CNO_1'] = ocno_chirality1_pos
motif_pos_fractory['O=CNO_2'] = ocno_chirality2_pos      


motif_pos_fractory['NC(=O)O'] = np.array([[ 1.3491534e+00, -1.4460659e-06, -7.0228339e-09],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-7.0059073e-01,  1.0193076e+00, -3.8944222e-08],
                                        [-6.2239188e-01, -1.2245626e+00,  5.1121488e-02]])     

motif_pos_fractory['O=S=O'] = np.array([[ 1.4988475e+00, -9.1360278e-07, -1.0043635e-08],
                                        [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                        [-6.5890151e-01,  1.3773243e+00,  2.0429866e-08]])

motif_pos_fractory['c1ccc2[nH]ccc2c1'] = np.array([[-2.7379730e+00, -6.1313069e-01, -1.6489333e-02],
                                                    [-2.3211720e+00,  7.2890872e-01, -9.0531819e-03],
                                                    [-9.5072848e-01,  1.0387094e+00,  1.6684453e-08],
                                                    [ 0.0000000e+00,  0.0000000e+00,  0.0000000e+00],
                                                    [ 1.3913009e+00, -1.8428735e-06, -1.6135573e-08],
                                                    [ 1.8455765e+00, -1.3102920e+00, -6.3695363e-03],
                                                    [ 7.8763163e-01, -2.1765461e+00, -1.6169764e-02],
                                                    [-3.9652774e-01, -1.3720552e+00, -1.5983881e-02],
                                                    [-1.7835701e+00, -1.6508858e+00, -2.4462869e-02]]) 

# motif_pos_fractory['O'] = np.array([[0,0,0]])  
# motif_pos_fractory['C'] = np.array([[0,0,0]])  
# motif_pos_fractory['N'] = np.array([[0,0,0]])  
# motif_pos_fractory['F'] = np.array([[0,0,0]])  
# motif_pos_fractory['Cl'] = np.array([[0,0,0]])  
# motif_pos_fractory['Br'] = np.array([[0,0,0]])  
# motif_pos_fractory['S'] = np.array([[0,0,0]])  
# motif_pos_fractory['I'] = np.array([[0,0,0]])  
# motif_pos_fractory['P'] = np.array([[0,0,0]])  

# motif_pos_fractory['Others']  = np.array([[0,0,0]])                                                                                                                                                              