import torch
import torch.nn.functional as F
import torchvision
from torchvision.models import resnet18
from networks import utils

class FCNet(torch.nn.Module):
    def __init__(self, indim=1, dims=[40,40], nonlins=['relu','relu']):
        super().__init__()
        self.net = utils.construct_fullcon_layers(indim, dims, nonlins)
        self.feat_dim = dims[-1]

    def forward(self, x):
        
        return self.net(x)

def get_backbone(backbone, **config):
    if backbone == 'fcnet_for_sineline':
        net = FCNet(indim=1, dims=[40,40], nonlins=['relu','relu'])
    else:
        raise NotImplementedError('Unknown backbone!')
    return net
