import pathlib
import sys
import warnings

from microsoft_nlp.rc import rc

if sys.platform.startswith("win"):  # pragma: no cover
    config_dir = pathlib.Path.home() / ".microsoft_nlp"
else:
    config_dir = pathlib.Path.home() / ".config" / "microsoft_nlp"

install_dir = pathlib.Path(__file__).parents[1]

rc_files = {  # in the order they will be read (lowest precedence to highest)
    "user": config_dir / "microsoft_nlp_rc",
    "project": pathlib.Path.cwd() / "microsoft_nlp_rc",
}
rc.reload_rc(filenames=rc_files.values())

datasets = rc.getpath(
    "dirs", "datasets", fallback=install_dir / "datasets"
).expanduser()
owt2_raw = datasets / "owt2-raw"
owt2_tokenized = datasets / "owt2-tokenized"
owt2_tokenized_nprecords = datasets / "owt2-tokenized-nprecords"
owt2_tokenized_tfrecords = datasets / "owt2-tokenized-tfrecords"
owt_openai_samples = datasets / "gpt-2-output-dataset"
logs = install_dir / "logs"
logs_sync = install_dir / "logs-sync"
weights = install_dir / "weights"
plots = install_dir / "plots"

recommended_dirs = (owt2_tokenized_nprecords,)
for path in recommended_dirs:
    if not path.is_dir():
        warnings.warn(f"{path} directory not found; see README for information")
