import numpy as np
import sympy as sy

complex_mult_flops = 6
complex_add_flops = 2
seq_len = 1024
# seq_len = 2048


def fft_ops(N):
    # based on pseudocode for radix-2 Cooley-Tukey FFT
    # https://en.wikipedia.org/wiki/Cooley%E2%80%93Tukey_FFT_algorithm#Pseudocode
    if N == 1:
        return 0

    K = N // 2
    ops = 2 * fft_ops(K)

    # butterfly has K complex multiplies and 2K complex adds
    ops += K * (complex_mult_flops + 2 * complex_add_flops)

    return ops


order = seq_len * np.log2(seq_len)
ops = fft_ops(seq_len)
print(ops)

assert ops % order == 0
factor = ops // order


q, n = sy.symbols("q n")

# best-case: padding adds nothing
fft = factor * n * sy.log(n, 2)
mults = complex_mult_flops * n * q
ifft = factor * q * n * sy.log(n, 2)
ops = fft + mults + ifft
ops_token = (ops / n).simplify()

# worst-case: padding makes n -> 2*n
worst_ops = ops.subs(n, 2 * n)
worst_ops_token = ops_token.subs(n, 2 * n)

print(worst_ops_token)
print(worst_ops_token.subs(n, seq_len).simplify())
