#!/usr/bin/env python

import io
import pathlib
import runpy

try:
    from setuptools import find_packages, setup
except ImportError:
    raise ImportError(
        "'setuptools' is required but not installed. To install it, "
        "follow the instructions at "
        "https://pip.pypa.io/en/stable/installing/#installing-with-get-pip-py"
    )


def read(*filenames, **kwargs):
    encoding = kwargs.get("encoding", "utf-8")
    sep = kwargs.get("sep", "\n")
    buf = []
    for filename in filenames:
        with io.open(filename, encoding=encoding) as f:
            buf.append(f.read())
    return sep.join(buf)


root = pathlib.Path(__file__).parent
version = runpy.run_path(str(root / "microsoft_nlp" / "version.py"))["version"]

install_req = [
    "click",
    "jsonlines",
    "matplotlib",
    "numpy",
    "scipy",
    "tensorflow>=2.3.0",
    "tqdm",
    "transformers",
    "zstandard",
]
docs_req = []
optional_req = []
tests_req = ["pytest"]

setup(
    name="microsoft-nlp",
    version=version,
    author="Applied Brain Research",
    author_email="info@appliedbrainresearch.com",
    packages=find_packages(),
    url="https://gl.appliedbrainresearch.com/abr/microsoft-nlp",
    include_package_data=True,
    description="ABR work for Microsoft NLP",
    long_description=read("README.md"),
    zip_safe=False,
    install_requires=install_req,
    extras_require={
        "all": docs_req + optional_req + tests_req,
        "docs": docs_req,
        "optional": optional_req,
        "tests": tests_req,
    },
    python_requires=">=3.8",
    entry_points={
        "console_scripts": [
            "microsoft-nlp=microsoft_nlp.cli:cli",
            "microsoft-nlp-results=microsoft_nlp.results:cli",
        ],
    },
)
